/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.sample;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.client.sample.Sampler;

public class SamplerConfiguration {
    private String className;
    private Map<String, String> options = new HashMap<String, String>();

    public SamplerConfiguration(Class<? extends Sampler> samplerClass) {
        this(samplerClass.getName());
    }

    public SamplerConfiguration(String samplerClassName) {
        Objects.requireNonNull(samplerClassName);
        this.className = samplerClassName;
    }

    public SamplerConfiguration setOptions(Map<String, String> options) {
        Objects.requireNonNull(options);
        this.options = new HashMap<String, String>(options.size());
        for (Map.Entry<String, String> entry : options.entrySet()) {
            this.addOption(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public SamplerConfiguration addOption(String option, String value) {
        Preconditions.checkArgument((option != null ? 1 : 0) != 0, (Object)"option is null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value is null");
        this.options.put(option, value);
        return this;
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public String getSamplerClassName() {
        return this.className;
    }

    public boolean equals(Object o) {
        if (o instanceof SamplerConfiguration) {
            SamplerConfiguration osc = (SamplerConfiguration)o;
            return this.className.equals(osc.className) && this.options.equals(osc.options);
        }
        return false;
    }

    public int hashCode() {
        return this.className.hashCode() + 31 * this.options.hashCode();
    }

    public String toString() {
        return this.className + " " + this.options;
    }
}

