/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin.compaction;

import java.util.Map;
import org.apache.accumulo.core.client.admin.compaction.CompactableFile;
import org.apache.accumulo.core.client.admin.compaction.CompactionConfigurer;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;

public class CompressionConfigurer
implements CompactionConfigurer {
    public static final String LARGE_FILE_COMPRESSION_THRESHOLD = "large.compress.threshold";
    public static final String LARGE_FILE_COMPRESSION_TYPE = "large.compress.type";
    private Long largeThresh;
    private String largeCompress;

    @Override
    public void init(CompactionConfigurer.InitParameters iparams) {
        Map<String, String> options = iparams.getOptions();
        String largeThresh = options.get(LARGE_FILE_COMPRESSION_THRESHOLD);
        String largeCompress = options.get(LARGE_FILE_COMPRESSION_TYPE);
        if (largeThresh != null && largeCompress != null) {
            this.largeThresh = ConfigurationTypeHelper.getFixedMemoryAsBytes(largeThresh);
            this.largeCompress = largeCompress;
        } else if (largeThresh != null ^ largeCompress != null) {
            throw new IllegalArgumentException("Must set both of " + Property.TABLE_COMPACTION_CONFIGURER_OPTS.getKey() + " (large.compress.type and large.compress.threshold) or neither for " + this.getClass().getName());
        }
    }

    @Override
    public CompactionConfigurer.Overrides override(CompactionConfigurer.InputParameters params) {
        long inputsSum = params.getInputFiles().stream().mapToLong(CompactableFile::getEstimatedSize).sum();
        if (inputsSum > this.largeThresh) {
            return new CompactionConfigurer.Overrides(Map.of(Property.TABLE_FILE_COMPRESSION_TYPE.getKey(), this.largeCompress));
        }
        return new CompactionConfigurer.Overrides(Map.of());
    }
}

