/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CloneConfiguration;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.DiskUsage;
import org.apache.accumulo.core.client.admin.ImportConfiguration;
import org.apache.accumulo.core.client.admin.Locations;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.SummaryRetriever;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.data.LoadPlan;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;

public interface TableOperations {
    public SortedSet<String> list();

    public boolean exists(String var1);

    public void create(String var1) throws AccumuloException, AccumuloSecurityException, TableExistsException;

    public void create(String var1, NewTableConfiguration var2) throws AccumuloSecurityException, AccumuloException, TableExistsException;

    default public void importTable(String tableName, String importDir) throws TableExistsException, AccumuloException, AccumuloSecurityException {
        this.importTable(tableName, Set.of(importDir), ImportConfiguration.empty());
    }

    public void importTable(String var1, Set<String> var2, ImportConfiguration var3) throws TableExistsException, AccumuloException, AccumuloSecurityException;

    public void exportTable(String var1, String var2) throws TableNotFoundException, AccumuloException, AccumuloSecurityException;

    public void addSplits(String var1, SortedSet<Text> var2) throws TableNotFoundException, AccumuloException, AccumuloSecurityException;

    public Collection<Text> listSplits(String var1) throws TableNotFoundException, AccumuloSecurityException, AccumuloException;

    public Collection<Text> listSplits(String var1, int var2) throws TableNotFoundException, AccumuloSecurityException, AccumuloException;

    public Locations locate(String var1, Collection<Range> var2) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public Text getMaxRow(String var1, Authorizations var2, Text var3, boolean var4, Text var5, boolean var6) throws TableNotFoundException, AccumuloException, AccumuloSecurityException;

    public void merge(String var1, Text var2, Text var3) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public void deleteRows(String var1, Text var2, Text var3) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public void compact(String var1, Text var2, Text var3, boolean var4, boolean var5) throws AccumuloSecurityException, TableNotFoundException, AccumuloException;

    public void compact(String var1, Text var2, Text var3, List<IteratorSetting> var4, boolean var5, boolean var6) throws AccumuloSecurityException, TableNotFoundException, AccumuloException;

    public void compact(String var1, CompactionConfig var2) throws AccumuloSecurityException, TableNotFoundException, AccumuloException;

    public void cancelCompaction(String var1) throws AccumuloSecurityException, TableNotFoundException, AccumuloException;

    public void delete(String var1) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public void clone(String var1, String var2, boolean var3, Map<String, String> var4, Set<String> var5) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException;

    public void clone(String var1, String var2, CloneConfiguration var3) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException;

    public void rename(String var1, String var2) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, TableExistsException;

    public void flush(String var1) throws AccumuloException, AccumuloSecurityException;

    public void flush(String var1, Text var2, Text var3, boolean var4) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public void setProperty(String var1, String var2, String var3) throws AccumuloException, AccumuloSecurityException;

    public Map<String, String> modifyProperties(String var1, Consumer<Map<String, String>> var2) throws AccumuloException, AccumuloSecurityException, IllegalArgumentException;

    public void removeProperty(String var1, String var2) throws AccumuloException, AccumuloSecurityException;

    default public Iterable<Map.Entry<String, String>> getProperties(String tableName) throws AccumuloException, TableNotFoundException {
        return this.getConfiguration(tableName).entrySet();
    }

    public Map<String, String> getConfiguration(String var1) throws AccumuloException, TableNotFoundException;

    public Map<String, String> getTableProperties(String var1) throws AccumuloException, TableNotFoundException;

    public void setLocalityGroups(String var1, Map<String, Set<Text>> var2) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public Map<String, Set<Text>> getLocalityGroups(String var1) throws AccumuloException, TableNotFoundException;

    public Set<Range> splitRangeByTablets(String var1, Range var2, int var3) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    default public ImportDestinationArguments importDirectory(String directory) {
        throw new UnsupportedOperationException();
    }

    public void offline(String var1) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public void offline(String var1, boolean var2) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public void online(String var1) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public void online(String var1, boolean var2) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public boolean isOnline(String var1) throws AccumuloException, TableNotFoundException;

    public void clearLocatorCache(String var1) throws TableNotFoundException;

    public Map<String, String> tableIdMap();

    public void attachIterator(String var1, IteratorSetting var2) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public void attachIterator(String var1, IteratorSetting var2, EnumSet<IteratorUtil.IteratorScope> var3) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public void removeIterator(String var1, String var2, EnumSet<IteratorUtil.IteratorScope> var3) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public IteratorSetting getIteratorSetting(String var1, String var2, IteratorUtil.IteratorScope var3) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public Map<String, EnumSet<IteratorUtil.IteratorScope>> listIterators(String var1) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public void checkIteratorConflicts(String var1, IteratorSetting var2, EnumSet<IteratorUtil.IteratorScope> var3) throws AccumuloException, TableNotFoundException;

    public int addConstraint(String var1, String var2) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public void removeConstraint(String var1, int var2) throws AccumuloException, AccumuloSecurityException;

    public Map<String, Integer> listConstraints(String var1) throws AccumuloException, TableNotFoundException;

    public List<DiskUsage> getDiskUsage(Set<String> var1) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public boolean testClassLoad(String var1, String var2, String var3) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public void setSamplerConfiguration(String var1, SamplerConfiguration var2) throws TableNotFoundException, AccumuloException, AccumuloSecurityException;

    public void clearSamplerConfiguration(String var1) throws TableNotFoundException, AccumuloException, AccumuloSecurityException;

    public SamplerConfiguration getSamplerConfiguration(String var1) throws TableNotFoundException, AccumuloException, AccumuloSecurityException;

    default public SummaryRetriever summaries(String tableName) {
        throw new UnsupportedOperationException();
    }

    default public void addSummarizers(String tableName, SummarizerConfiguration ... summarizers) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        throw new UnsupportedOperationException();
    }

    default public void removeSummarizers(String tableName, Predicate<SummarizerConfiguration> predicate) throws AccumuloException, TableNotFoundException, AccumuloSecurityException {
        throw new UnsupportedOperationException();
    }

    default public List<SummarizerConfiguration> listSummarizers(String tableName) throws AccumuloException, TableNotFoundException {
        throw new UnsupportedOperationException();
    }

    default public TimeType getTimeType(String tableName) throws TableNotFoundException {
        throw new UnsupportedOperationException();
    }

    public static interface ImportDestinationArguments {
        public ImportMappingOptions to(String var1);
    }

    public static interface ImportMappingOptions
    extends ImportOptions {
        public static final String BULK_LOAD_THREADS_DEFAULT = "8C";

        public ImportOptions plan(LoadPlan var1);

        public ImportOptions executor(Executor var1);

        public ImportOptions threads(int var1);
    }

    public static interface ImportOptions {
        public ImportMappingOptions tableTime(boolean var1);

        public ImportMappingOptions ignoreEmptyDir(boolean var1);

        public void load() throws TableNotFoundException, IOException, AccumuloException, AccumuloSecurityException;
    }
}

