/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoopImpl.mapred;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.hadoop.mapred.AccumuloOutputFormat;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.OutputConfigurator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloRecordWriter
implements RecordWriter<Text, Mutation> {
    private static final Class<AccumuloOutputFormat> CLASS = AccumuloOutputFormat.class;
    private static final Logger log = LoggerFactory.getLogger(AccumuloRecordWriter.class);
    private MultiTableBatchWriter mtbw = null;
    private final HashMap<Text, BatchWriter> bws;
    private final Text defaultTableName;
    private final boolean simulate;
    private final boolean createTables;
    private long mutCount = 0L;
    private long valCount = 0L;
    private AccumuloClient client;

    public AccumuloRecordWriter(JobConf job) {
        this.simulate = OutputConfigurator.getSimulationMode(CLASS, (Configuration)job);
        this.createTables = OutputConfigurator.canCreateTables(CLASS, (Configuration)job);
        if (this.simulate) {
            log.info("Simulating output only. No writes to tables will occur");
        }
        this.bws = new HashMap();
        String tname = OutputConfigurator.getDefaultTableName(CLASS, (Configuration)job);
        Text text = this.defaultTableName = tname == null ? null : new Text(tname);
        if (!this.simulate) {
            this.client = OutputConfigurator.createClient(CLASS, (Configuration)job);
            this.mtbw = this.client.createMultiTableBatchWriter();
        }
    }

    public void write(Text table, Mutation mutation) throws IOException {
        if (table == null || table.getLength() == 0) {
            table = this.defaultTableName;
        }
        if (!this.simulate && table == null) {
            throw new IOException("No table or default table specified. Try simulation mode next time");
        }
        ++this.mutCount;
        this.valCount += (long)mutation.size();
        this.printMutation(table, mutation);
        if (this.simulate) {
            return;
        }
        if (!this.bws.containsKey(table)) {
            try {
                this.addTable(table);
            }
            catch (AccumuloException | AccumuloSecurityException e) {
                log.error("Could not add table '" + String.valueOf(table) + "'", e);
                throw new IOException(e);
            }
        }
        try {
            this.bws.get(table).addMutation(mutation);
        }
        catch (MutationsRejectedException e) {
            throw new IOException(e);
        }
    }

    protected void addTable(Text tableName) throws AccumuloException, AccumuloSecurityException {
        if (this.simulate) {
            log.info("Simulating adding table: " + String.valueOf(tableName));
            return;
        }
        log.debug("Adding table: " + String.valueOf(tableName));
        BatchWriter bw = null;
        String table = tableName.toString();
        if (this.createTables && !this.client.tableOperations().exists(table)) {
            try {
                this.client.tableOperations().create(table);
            }
            catch (AccumuloSecurityException e) {
                log.error("Accumulo security violation creating " + table, (Throwable)e);
                throw e;
            }
            catch (TableExistsException e) {
                // empty catch block
            }
        }
        try {
            bw = this.mtbw.getBatchWriter(table);
        }
        catch (TableNotFoundException e) {
            log.error("Accumulo table " + table + " doesn't exist and cannot be created.", (Throwable)e);
            throw new AccumuloException((Throwable)e);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw e;
        }
        if (bw != null) {
            this.bws.put(tableName, bw);
        }
    }

    private int printMutation(Text table, Mutation m) {
        if (log.isTraceEnabled()) {
            log.trace(String.format("Table %s row key: %s", table, this.hexDump(m.getRow())));
            for (ColumnUpdate cu : m.getUpdates()) {
                log.trace(String.format("Table %s column: %s:%s", table, this.hexDump(cu.getColumnFamily()), this.hexDump(cu.getColumnQualifier())));
                log.trace(String.format("Table %s security: %s", table, new ColumnVisibility(cu.getColumnVisibility()).toString()));
                log.trace(String.format("Table %s value: %s", table, this.hexDump(cu.getValue())));
            }
        }
        return m.getUpdates().size();
    }

    private String hexDump(byte[] ba) {
        StringBuilder sb = new StringBuilder();
        for (byte b : ba) {
            if (b > 32 && b < 126) {
                sb.append((char)b);
                continue;
            }
            sb.append(String.format("x%02x", b));
        }
        return sb.toString();
    }

    public void close(Reporter reporter) throws IOException {
        log.debug("mutations written: " + this.mutCount + ", values written: " + this.valCount);
        if (this.simulate) {
            return;
        }
        try {
            this.mtbw.close();
        }
        catch (MutationsRejectedException e) {
            if (!e.getSecurityErrorCodes().isEmpty()) {
                HashMap tables = new HashMap();
                e.getSecurityErrorCodes().forEach((tabletId, codes) -> tables.computeIfAbsent(tabletId.getTable().canonical(), k -> new HashSet()).addAll(codes));
                log.error("Not authorized to write to tables : " + String.valueOf(tables));
            }
            if (!e.getConstraintViolationSummaries().isEmpty()) {
                log.error("Constraint violations : " + e.getConstraintViolationSummaries().size());
            }
            throw new IOException(e);
        }
        finally {
            this.client.close();
        }
    }
}

