/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.BulkImportListIterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ListBulkCommand
extends Shell.Command {
    private Option tserverOption;
    private Option disablePaginationOpt;

    @Override
    public String description() {
        return "lists what bulk imports are currently running in accumulo.";
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        List<String> tservers;
        boolean paginate;
        ClientContext context = shellState.getContext();
        ManagerMonitorInfo stats = (ManagerMonitorInfo)ThriftClientTypes.MANAGER.execute(context, client -> client.getManagerStats(TraceUtil.traceInfo(), context.rpcCreds()));
        boolean bl = paginate = !cl.hasOption(this.disablePaginationOpt.getOpt());
        if (cl.hasOption(this.tserverOption.getOpt())) {
            tservers = new ArrayList();
            tservers.add(cl.getOptionValue(this.tserverOption.getOpt()));
        } else {
            tservers = Collections.emptyList();
        }
        shellState.printLines(new BulkImportListIterator(tservers, stats), paginate);
        return 0;
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options opts = new Options();
        this.tserverOption = new Option("ts", "tabletServer", true, "tablet server to list bulk imports");
        this.tserverOption.setArgName("tablet server");
        opts.addOption(this.tserverOption);
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disable pagination of output");
        opts.addOption(this.disablePaginationOpt);
        return opts;
    }
}

