/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class ImportDirectoryCommand
extends Shell.Command {
    @Override
    public String description() {
        return "bulk imports an entire directory of data files into an existing table. The table is either passed with the -t tablename opt, or into to the current table if the -t option is not provided. The boolean argument determines if accumulo sets the time. If the -i ignore option is supplied then no exception will be thrown when attempting to import files from an empty source directory. An info log message will be displayed indicating the source directory is empty, but no error is thrown.\n Passing 3 arguments will use the old bulk import. The new bulk import only takes 2 arguments:  <directory> true|false";
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        boolean ignore = OptUtil.getIgnoreEmptyDirOpt(cl, shellState);
        String[] args = cl.getArgs();
        String dir = args.length > 0 ? args[0] : "";
        int status = 0;
        switch (args.length) {
            case 2: {
                boolean setTime = Boolean.parseBoolean(cl.getArgs()[1]);
                shellState.getAccumuloClient().tableOperations().importDirectory(dir).to(tableName).tableTime(setTime).ignoreEmptyDir(ignore).load();
                break;
            }
            case 3: {
                Shell.log.warn("Deprecated since 2.0.0. New bulk import technique does not take a failure directory as an argument.");
                String failureDir = args[1];
                boolean setTime = Boolean.parseBoolean(cl.getArgs()[2]);
                shellState.getAccumuloClient().tableOperations().importDirectory(tableName, dir, failureDir, setTime);
                break;
            }
            default: {
                shellState.printException(new IllegalArgumentException(String.format("Expected 2 or 3 arguments. There %s %d.", args.length == 1 ? "was" : "were", args.length)));
                this.printHelp(shellState);
                status = 1;
            }
        }
        return status;
    }

    @Override
    public int numArgs() {
        return -1;
    }

    @Override
    public String usage() {
        return this.getName() + " <directory> [failureDirectory] true|false";
    }

    @Override
    public Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption(OptUtil.tableOpt("name of the table to import files into"));
        opts.addOption(OptUtil.ignoreEmptyDirOpt("ignore empty bulk import source directory"));
        return opts;
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> completionSet) {
        this.registerCompletionForTables(root, completionSet);
    }
}

