/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.format.FormatterConfig;
import org.apache.accumulo.core.util.interpret.ScanInterpreter;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.accumulo.shell.commands.ScanCommand;
import org.apache.accumulo.shell.format.DeleterFormatter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class DeleteManyCommand
extends ScanCommand {
    private Option forceOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        ScanInterpreter interpreter = this.getInterpreter(cl, tableName, shellState);
        Authorizations auths = this.getAuths(cl, shellState);
        Scanner scanner = shellState.getAccumuloClient().createScanner(tableName, auths);
        scanner.addScanIterator(new IteratorSetting(Integer.MAX_VALUE, "NOVALUE", SortedKeyIterator.class));
        this.addScanIterators(shellState, cl, (ScannerBase)scanner, tableName);
        scanner.setRange(this.getRange(cl, interpreter));
        scanner.setTimeout(this.getTimeout(cl), TimeUnit.MILLISECONDS);
        this.fetchColumns(cl, (ScannerBase)scanner, interpreter);
        BatchWriter writer = shellState.getAccumuloClient().createBatchWriter(tableName, new BatchWriterConfig().setTimeout(this.getTimeout(cl), TimeUnit.MILLISECONDS));
        FormatterConfig config = new FormatterConfig();
        config.setPrintTimestamps(cl.hasOption(this.timestampOpt.getOpt()));
        shellState.printLines((Iterator<String>)((Object)new DeleterFormatter(writer, (Iterable<Map.Entry<Key, Value>>)scanner, config, shellState, cl.hasOption(this.forceOpt.getOpt()))), false);
        return 0;
    }

    @Override
    public String description() {
        return "scans a table and deletes the resulting records";
    }

    @Override
    public Options getOptions() {
        this.forceOpt = new Option("f", "force", false, "force deletion without prompting");
        Options opts = super.getOptions();
        opts.addOption(this.forceOpt);
        opts.addOption(OptUtil.tableOpt("table to delete entries from"));
        return opts;
    }
}

