/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CreateNamespaceCommand
extends Shell.Command {
    private Option createNamespaceOptCopyConfig;
    private Option createNamesapceOptExcludeParentProps;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, IOException, ClassNotFoundException, NamespaceExistsException, NamespaceNotFoundException {
        if (cl.hasOption(this.createNamesapceOptExcludeParentProps.getLongOpt()) && !cl.hasOption(this.createNamespaceOptCopyConfig.getOpt())) {
            throw new IllegalArgumentException(this.createNamesapceOptExcludeParentProps.getLongOpt() + " only valid when using " + this.createNamespaceOptCopyConfig.getLongOpt());
        }
        String namespace = cl.getArgs()[0];
        shellState.getAccumuloClient().namespaceOperations().create(namespace);
        if (!shellState.getAccumuloClient().namespaceOperations().exists(namespace)) {
            throw new IllegalArgumentException("Could not create namespace `" + namespace + "`");
        }
        if (cl.hasOption(this.createNamespaceOptCopyConfig.getOpt())) {
            String srcNs = cl.getOptionValue(this.createNamespaceOptCopyConfig.getOpt());
            if (!srcNs.isEmpty() && !shellState.getAccumuloClient().namespaceOperations().exists(srcNs)) {
                throw new NamespaceNotFoundException(null, srcNs, null);
            }
            Map userProps = cl.hasOption(this.createNamesapceOptExcludeParentProps.getLongOpt()) ? shellState.getAccumuloClient().namespaceOperations().getNamespaceProperties(srcNs) : shellState.getAccumuloClient().namespaceOperations().getConfiguration(srcNs);
            if (userProps != null) {
                Map props = userProps;
                shellState.getAccumuloClient().namespaceOperations().modifyProperties(namespace, properties -> props.entrySet().stream().filter(entry -> Property.isValidTablePropertyKey((String)((String)entry.getKey()))).forEach(entry -> properties.put((String)entry.getKey(), (String)entry.getValue())));
            }
        }
        return 0;
    }

    @Override
    public String description() {
        return "creates a new namespace";
    }

    @Override
    public String usage() {
        return this.getName() + " <namespaceName>";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.createNamespaceOptCopyConfig = new Option("cc", "copy-config", true, "namespace to copy configuration from");
        this.createNamespaceOptCopyConfig.setArgName("namespace");
        this.createNamesapceOptExcludeParentProps = new Option(null, "exclude-parent-properties", false, "exclude properties from its parent(s) when copying configuration");
        o.addOption(this.createNamespaceOptCopyConfig);
        o.addOption(this.createNamesapceOptExcludeParentProps);
        return o;
    }

    @Override
    public int numArgs() {
        return 1;
    }
}

