/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.zookeeper;

import java.util.List;
import java.util.Objects;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooAclUtil {
    private static final Logger log = LoggerFactory.getLogger(ZooAclUtil.class);

    private ZooAclUtil() {
    }

    public static String extractAuthName(ACL acl) {
        Objects.requireNonNull(acl, "provided ACL cannot be null");
        try {
            return acl.getId().getId().trim().split(":")[0];
        }
        catch (Exception ex) {
            log.debug("Invalid ACL passed, cannot parse id from '{}'", (Object)acl);
            return "";
        }
    }

    public static String translateZooPerm(int perm) {
        if (perm == 31) {
            return "cdrwa";
        }
        StringBuilder sb = new StringBuilder();
        if ((perm & 4) != 0) {
            sb.append("c");
        }
        if ((perm & 8) != 0) {
            sb.append("d");
        }
        if ((perm & 1) != 0) {
            sb.append("r");
        }
        if ((perm & 2) != 0) {
            sb.append("w");
        }
        if ((perm & 0x10) != 0) {
            sb.append("a");
        }
        if (sb.length() == 0) {
            return "invalid";
        }
        return sb.toString();
    }

    public static ZkAccumuloAclStatus checkWritableAuth(List<ACL> acls) {
        ZkAccumuloAclStatus result = new ZkAccumuloAclStatus();
        for (ACL a : acls) {
            String name = ZooAclUtil.extractAuthName(a);
            if (("accumulo".equals(name) || "anyone".equals(name)) && a.getPerms() == 31) {
                result.setAccumuloHasFull();
            }
            if (!"accumulo".equals(name) && (a.getPerms() & 0xFFFFFFFE) != 0) {
                result.setOthersMayUpdate();
            }
            if ("accumulo".equals(name) || (a.getPerms() & 1) == 0) continue;
            result.setAnyCanRead();
        }
        return result;
    }

    public static class ZkAccumuloAclStatus {
        private boolean accumuloHasFull = false;
        private boolean othersMayUpdate = false;
        private boolean anyCanRead = false;

        public boolean accumuloHasFull() {
            return this.accumuloHasFull;
        }

        public void setAccumuloHasFull() {
            this.accumuloHasFull = true;
        }

        public boolean othersMayUpdate() {
            return this.othersMayUpdate;
        }

        public void setOthersMayUpdate() {
            this.othersMayUpdate = true;
        }

        public boolean anyCanRead() {
            return this.anyCanRead;
        }

        public void setAnyCanRead() {
            this.anyCanRead = true;
        }

        public String toString() {
            return "ZkAccumuloAclStatus{accumuloHasFull=" + this.accumuloHasFull + ", anyMayUpdate=" + this.othersMayUpdate + ", anyCanRead=" + this.anyCanRead + "}";
        }
    }
}

