/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.balancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.spi.balancer.SimpleLoadBalancer;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.server.master.balancer.TabletBalancer;
import org.apache.accumulo.server.master.state.TabletMigration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="2.1.0")
public class DefaultLoadBalancer
extends TabletBalancer {
    private static final Logger log = LoggerFactory.getLogger(DefaultLoadBalancer.class);
    Iterator<TServerInstance> assignments;
    TableId tableToBalance = null;
    private static final TabletBalancer.NoTservers NO_SERVERS = new TabletBalancer.NoTservers(log);
    protected final TabletBalancer.OutstandingMigrations outstandingMigrations = new TabletBalancer.OutstandingMigrations(log);

    public DefaultLoadBalancer() {
        log.warn("{} has been deprecated and will be removed in a future release. Please update your configuration to use the equivalent {} instead.", (Object)this.getClass().getName(), (Object)SimpleLoadBalancer.class.getName());
    }

    public DefaultLoadBalancer(TableId table) {
        this();
        this.tableToBalance = table;
    }

    List<TServerInstance> randomize(Set<TServerInstance> locations) {
        ArrayList<TServerInstance> result = new ArrayList<TServerInstance>(locations);
        Collections.shuffle(result);
        return result;
    }

    public TServerInstance getAssignment(SortedMap<TServerInstance, TabletServerStatus> locations, TServerInstance last) {
        TServerInstance result;
        if (locations.isEmpty()) {
            return null;
        }
        if (last != null) {
            TServerInstance current;
            String fakeSessionID = " ";
            TServerInstance simple = new TServerInstance(last.getHostAndPort(), fakeSessionID);
            Iterator<TServerInstance> find = locations.tailMap(simple).keySet().iterator();
            if (find.hasNext() && (current = find.next()).getHost().equals(last.getHost())) {
                return current;
            }
        }
        if (this.assignments == null || !this.assignments.hasNext()) {
            this.assignments = this.randomize(locations.keySet()).iterator();
        }
        if (!locations.containsKey(result = this.assignments.next())) {
            this.assignments = null;
            return this.randomize(locations.keySet()).iterator().next();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMigrations(Map<TServerInstance, TabletServerStatus> current, List<TabletMigration> result) {
        boolean moreBalancingNeeded = false;
        try {
            if (current.size() < 2) {
                boolean bl = false;
                return bl;
            }
            HashMap<TableId, Map<KeyExtent, TabletStats>> donerTabletStats = new HashMap<TableId, Map<KeyExtent, TabletStats>>();
            int total = 0;
            ArrayList<ServerCounts> totals = new ArrayList<ServerCounts>();
            for (Map.Entry<TServerInstance, TabletServerStatus> entry : current.entrySet()) {
                int serverTotal = 0;
                if (entry.getValue() != null && entry.getValue().tableMap != null) {
                    for (Map.Entry e : entry.getValue().tableMap.entrySet()) {
                        if (this.tableToBalance != null && !this.tableToBalance.canonical().equals(e.getKey())) continue;
                        serverTotal += ((TableInfo)e.getValue()).onlineTablets;
                    }
                }
                totals.add(new ServerCounts(serverTotal, entry.getKey(), entry.getValue()));
                total += serverTotal;
            }
            totals.sort(Collections.reverseOrder());
            int even = total / totals.size();
            int numServersOverEven = total % totals.size();
            int end = totals.size() - 1;
            int movedAlready = 0;
            int tooManyIndex = 0;
            while (tooManyIndex < end) {
                ServerCounts tooMany = (ServerCounts)totals.get(tooManyIndex);
                int goal = even;
                if (tooManyIndex < numServersOverEven) {
                    ++goal;
                }
                int needToUnload = tooMany.count - goal;
                ServerCounts tooLittle = (ServerCounts)totals.get(end);
                int needToLoad = goal - tooLittle.count - movedAlready;
                if (needToUnload < 1 && needToLoad < 1) {
                    break;
                }
                if (needToUnload >= needToLoad) {
                    result.addAll(this.move(tooMany, tooLittle, needToLoad, donerTabletStats));
                    --end;
                    movedAlready = 0;
                } else {
                    result.addAll(this.move(tooMany, tooLittle, needToUnload, donerTabletStats));
                    movedAlready += needToUnload;
                }
                if (needToUnload > needToLoad) {
                    moreBalancingNeeded = true;
                    continue;
                }
                ++tooManyIndex;
                donerTabletStats.clear();
            }
        }
        finally {
            log.trace("balance ended with {} migrations", (Object)result.size());
        }
        return moreBalancingNeeded;
    }

    List<TabletMigration> move(ServerCounts tooMuch, ServerCounts tooLittle, int count, Map<TableId, Map<KeyExtent, TabletStats>> donerTabletStats) {
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<TabletMigration> result = new ArrayList<TabletMigration>();
        Map<TableId, Integer> tooMuchMap = DefaultLoadBalancer.tabletCountsPerTable(tooMuch.status);
        Map<TableId, Integer> tooLittleMap = DefaultLoadBalancer.tabletCountsPerTable(tooLittle.status);
        for (int i = 0; i < count; ++i) {
            TableId table;
            if (this.tableToBalance == null) {
                int biggestDifference = 0;
                TableId biggestDifferenceTable = null;
                for (Map.Entry<TableId, Integer> tableEntry : tooMuchMap.entrySet()) {
                    TableId tableID = tableEntry.getKey();
                    tooLittleMap.putIfAbsent(tableID, 0);
                    int diff = tableEntry.getValue() - tooLittleMap.get(tableID);
                    if (diff <= biggestDifference) continue;
                    biggestDifference = diff;
                    biggestDifferenceTable = tableID;
                }
                table = biggestDifference < 2 ? DefaultLoadBalancer.busiest(tooMuch.status.tableMap) : biggestDifferenceTable;
            } else {
                table = this.tableToBalance;
            }
            Map<KeyExtent, TabletStats> onlineTabletsForTable = donerTabletStats.get(table);
            try {
                if (onlineTabletsForTable == null) {
                    onlineTabletsForTable = new HashMap<KeyExtent, TabletStats>();
                    List<TabletStats> stats = this.getOnlineTabletsForTable(tooMuch.server, table);
                    if (stats == null) {
                        log.warn("Unable to find tablets to move");
                        return result;
                    }
                    for (TabletStats stat : stats) {
                        onlineTabletsForTable.put(KeyExtent.fromThrift((TKeyExtent)stat.extent), stat);
                    }
                    donerTabletStats.put(table, onlineTabletsForTable);
                }
            }
            catch (Exception ex) {
                log.error("Unable to select a tablet to move", (Throwable)ex);
                return result;
            }
            KeyExtent extent = DefaultLoadBalancer.selectTablet(onlineTabletsForTable);
            onlineTabletsForTable.remove(extent);
            if (extent == null) {
                return result;
            }
            tooMuchMap.put(table, tooMuchMap.get(table) - 1);
            Integer tooLittleCount = tooLittleMap.get(table);
            if (tooLittleCount == null) {
                tooLittleCount = 0;
            }
            tooLittleMap.put(table, tooLittleCount + 1);
            --tooMuch.count;
            ++tooLittle.count;
            result.add(new TabletMigration(extent, tooMuch.server, tooLittle.server));
        }
        return result;
    }

    static Map<TableId, Integer> tabletCountsPerTable(TabletServerStatus status) {
        HashMap<TableId, Integer> result = new HashMap<TableId, Integer>();
        if (status != null && status.tableMap != null) {
            Map tableMap = status.tableMap;
            for (Map.Entry entry : tableMap.entrySet()) {
                result.put(TableId.of((String)((String)entry.getKey())), ((TableInfo)entry.getValue()).onlineTablets);
            }
        }
        return result;
    }

    static KeyExtent selectTablet(Map<KeyExtent, TabletStats> extents) {
        if (extents.isEmpty()) {
            return null;
        }
        KeyExtent mostRecentlySplit = null;
        long splitTime = 0L;
        for (Map.Entry<KeyExtent, TabletStats> entry : extents.entrySet()) {
            if (entry.getValue().splitCreationTime < splitTime) continue;
            splitTime = entry.getValue().splitCreationTime;
            mostRecentlySplit = entry.getKey();
        }
        return mostRecentlySplit;
    }

    private static TableId busiest(Map<String, TableInfo> tables) {
        TableId result = null;
        double busiest = Double.NEGATIVE_INFINITY;
        for (Map.Entry<String, TableInfo> entry : tables.entrySet()) {
            TableInfo info = entry.getValue();
            double busy = info.ingestRate + info.queryRate;
            if (!(busy > busiest)) continue;
            busiest = busy;
            result = TableId.of((String)entry.getKey());
        }
        return result;
    }

    @Override
    public void getAssignments(SortedMap<TServerInstance, TabletServerStatus> current, Map<KeyExtent, TServerInstance> unassigned, Map<KeyExtent, TServerInstance> assignments) {
        for (Map.Entry<KeyExtent, TServerInstance> entry : unassigned.entrySet()) {
            assignments.put(entry.getKey(), this.getAssignment(current, entry.getValue()));
        }
    }

    @Override
    public long balance(SortedMap<TServerInstance, TabletServerStatus> current, Set<KeyExtent> migrations, List<TabletMigration> migrationsOut) {
        if (current.isEmpty()) {
            this.constraintNotMet(NO_SERVERS);
        } else if (migrations.isEmpty()) {
            this.resetBalancerErrors();
            if (this.getMigrations(current, migrationsOut)) {
                return 1000L;
            }
        } else {
            this.outstandingMigrations.migrations = migrations;
            this.constraintNotMet(this.outstandingMigrations);
        }
        return 5000L;
    }

    static class ServerCounts
    implements Comparable<ServerCounts> {
        public final TServerInstance server;
        public int count;
        public final TabletServerStatus status;

        ServerCounts(int count, TServerInstance server, TabletServerStatus status) {
            this.count = count;
            this.server = server;
            this.status = status;
        }

        public int hashCode() {
            return Objects.hashCode(this.server) + this.count;
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof ServerCounts && this.compareTo((ServerCounts)obj) == 0;
        }

        @Override
        public int compareTo(ServerCounts obj) {
            int result = this.count - obj.count;
            if (result == 0) {
                return this.server.compareTo(obj.server);
            }
            return result;
        }
    }
}

