/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.util;

import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import java.util.TreeSet;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.apache.accumulo.server.conf.codec.VersionedPropCodec;
import org.apache.accumulo.server.conf.store.NamespacePropKey;
import org.apache.accumulo.server.conf.store.SystemPropKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.server.conf.store.impl.PropStoreWatcher;
import org.apache.accumulo.server.conf.store.impl.ReadyMonitor;
import org.apache.accumulo.server.conf.util.ConfigTransformer;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={KeywordExecutable.class})
public class ConfigPropertyUpgrader
implements KeywordExecutable {
    private static final Logger log = LoggerFactory.getLogger(ConfigPropertyUpgrader.class);
    private static final VersionedPropCodec codec = VersionedPropCodec.getDefault();

    public static void main(String[] args) throws Exception {
        new ConfigPropertyUpgrader().execute(args);
    }

    public String keyword() {
        return "config-upgrade";
    }

    public String description() {
        return "converts properties store in ZooKeeper to 2.1 format";
    }

    public void execute(String[] args) throws Exception {
        ServerUtilOpts opts = new ServerUtilOpts();
        opts.parseArgs(ConfigPropertyUpgrader.class.getName(), args, new Object[0]);
        ServerContext context = opts.getServerContext();
        this.doUpgrade(context.getInstanceID(), context.getZooReaderWriter());
    }

    public void doUpgrade(InstanceId instanceId, ZooReaderWriter zrw) {
        ReadyMonitor readyMonitor = new ReadyMonitor(ConfigPropertyUpgrader.class.getSimpleName(), (long)zrw.getSessionTimeout() * 2L);
        PropStoreWatcher nullWatcher = new PropStoreWatcher(readyMonitor);
        ConfigTransformer transformer = new ConfigTransformer(zrw, codec, nullWatcher);
        this.upgradeSysProps(instanceId, transformer);
        this.upgradeNamespaceProps(instanceId, zrw, transformer);
        this.upgradeTableProps(instanceId, zrw, transformer);
    }

    @VisibleForTesting
    void upgradeSysProps(InstanceId instanceId, ConfigTransformer transformer) {
        log.info("Upgrade system config properties for {}", (Object)instanceId);
        String legacyPath = ZooUtil.getRoot((InstanceId)instanceId) + "/config";
        transformer.transform(SystemPropKey.of(instanceId), legacyPath, false);
    }

    @VisibleForTesting
    void upgradeNamespaceProps(InstanceId instanceId, ZooReaderWriter zrw, ConfigTransformer transformer) {
        String zkPathNamespaceBase = ZooUtil.getRoot((InstanceId)instanceId) + "/namespaces";
        try {
            TreeSet namespaces = new TreeSet(zrw.getChildren(zkPathNamespaceBase));
            for (String namespace : namespaces) {
                String legacyPath = zkPathNamespaceBase + "/" + namespace + "/conf";
                log.info("Upgrading namespace {} base path: {}", (Object)namespace, (Object)legacyPath);
                transformer.transform(NamespacePropKey.of(instanceId, NamespaceId.of((String)namespace)), legacyPath, true);
            }
        }
        catch (KeeperException ex) {
            throw new IllegalStateException("Failed to read namespaces from ZooKeeper for path: " + zkPathNamespaceBase, ex);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Interrupted reading namespaces from ZooKeeper for path: " + zkPathNamespaceBase, ex);
        }
    }

    @VisibleForTesting
    void upgradeTableProps(InstanceId instanceId, ZooReaderWriter zrw, ConfigTransformer transformer) {
        String zkPathTableBase = ZooUtil.getRoot((InstanceId)instanceId) + "/tables";
        try {
            TreeSet tables = new TreeSet(zrw.getChildren(zkPathTableBase));
            for (String table : tables) {
                String legacyPath = zkPathTableBase + "/" + table + "/conf";
                log.info("Upgrading table {} base path: {}", (Object)table, (Object)legacyPath);
                transformer.transform(TablePropKey.of(instanceId, TableId.of((String)table)), legacyPath, true);
            }
        }
        catch (KeeperException ex) {
            throw new IllegalStateException("Failed to read tables from ZooKeeper for path: " + zkPathTableBase, ex);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Interrupted reading tables from ZooKeeper for path: " + zkPathTableBase, ex);
        }
    }
}

