/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.store.impl;

import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ReadyMonitor {
    private final String resourceName;
    private final long timeout;
    private final AtomicBoolean haveConnection = new AtomicBoolean(false);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition readySignal = this.lock.newCondition();

    public ReadyMonitor(String resourceName, long timeout) {
        this.resourceName = resourceName;
        this.timeout = timeout;
    }

    public boolean test() {
        if (this.isClosed.get()) {
            throw new IllegalStateException("ZooKeeper has closed the connection - cannot continue");
        }
        return this.haveConnection.get();
    }

    public void isReady() {
        if (this.test()) {
            return;
        }
        while (!this.haveConnection.get()) {
            try {
                this.lock.lock();
                if (!this.readySignal.await(this.timeout, TimeUnit.MILLISECONDS)) {
                    String msg = this.resourceName + " failed to be ready within " + this.timeout + " ms";
                    throw new IllegalStateException(msg);
                }
                this.readySignal.signalAll();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(this.resourceName + " interrupted while waiting until ready ", ex);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void setClosed() {
        this.isClosed.set(true);
    }

    public void setReady() {
        if (this.test()) {
            return;
        }
        try {
            this.lock.lock();
            this.haveConnection.set(true);
            this.readySignal.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearReady() {
        this.haveConnection.set(false);
    }

    public String toString() {
        return new StringJoiner(", ", ReadyMonitor.class.getSimpleName() + "[", "]").add("resourceName='" + this.resourceName + "'").add("timeout=" + this.timeout).add("haveConnection=" + String.valueOf(this.haveConnection)).toString();
    }
}

