/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.volume;

import java.io.IOException;
import java.util.Objects;
import org.apache.accumulo.core.volume.Volume;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeImpl
implements Volume {
    private static final Logger log = LoggerFactory.getLogger(VolumeImpl.class);
    private final FileSystem fs;
    private final String basePath;
    private final Configuration hadoopConf;

    public VolumeImpl(Path path, Configuration hadoopConf) throws IOException {
        this.fs = Objects.requireNonNull(path).getFileSystem(Objects.requireNonNull(hadoopConf));
        this.basePath = VolumeImpl.stripTrailingSlashes(path.toUri().getPath());
        this.hadoopConf = hadoopConf;
    }

    public VolumeImpl(FileSystem fs, String basePath) {
        this.fs = Objects.requireNonNull(fs);
        this.basePath = VolumeImpl.stripTrailingSlashes(Objects.requireNonNull(basePath));
        this.hadoopConf = fs.getConf();
    }

    private static String stripTrailingSlashes(String path) {
        return path.strip().replaceAll("/*$", "");
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public boolean containsPath(Path path) {
        FileSystem otherFS;
        try {
            otherFS = Objects.requireNonNull(path).getFileSystem(this.hadoopConf);
        }
        catch (IOException e) {
            log.warn("Could not determine filesystem from path: {}", (Object)path, (Object)e);
            return false;
        }
        return this.equivalentFileSystems(otherFS) && this.isAncestorPathOf(path);
    }

    boolean equivalentFileSystems(FileSystem otherFS) {
        return VolumeImpl.stripTrailingSlashes(this.fs.getUri().toString()).equals(VolumeImpl.stripTrailingSlashes(otherFS.getUri().toString()));
    }

    boolean isAncestorPathOf(Path other) {
        String otherPath = other.toUri().getPath().strip();
        if (otherPath.startsWith(this.basePath)) {
            String otherRemainingPath = otherPath.substring(this.basePath.length());
            return otherRemainingPath.isEmpty() || otherRemainingPath.startsWith("/") && !otherRemainingPath.contains("..");
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getFileSystem()) + Objects.hashCode(this.getBasePath());
    }

    public boolean equals(Object o) {
        if (o instanceof VolumeImpl) {
            VolumeImpl other = (VolumeImpl)o;
            return this.getFileSystem().equals(other.getFileSystem()) && this.getBasePath().equals(other.getBasePath());
        }
        return false;
    }

    public String toString() {
        return this.fs.makeQualified(new Path(this.basePath)).toString();
    }

    @Override
    public Path prefixChild(String pathString) {
        String reason;
        String p = Objects.requireNonNull(pathString).strip();
        String string = p = p.startsWith("/") ? p.substring(1) : p;
        if (this.basePath.isBlank()) {
            log.error("Basepath is empty. Make sure instance.volumes is set to a correct path");
            throw new IllegalArgumentException("Accumulo cannot be initialized because basepath is empty. This probably means instance.volumes is an incorrect value");
        }
        if (p.isBlank()) {
            return this.fs.makeQualified(new Path(this.basePath));
        }
        if (p.startsWith("/")) {
            reason = "absolute path";
        } else if (pathString.contains(":")) {
            reason = "qualified path";
        } else if (pathString.contains("..")) {
            reason = "path contains '..'";
        } else {
            return this.fs.makeQualified(new Path(this.basePath, p));
        }
        throw new IllegalArgumentException(String.format("Cannot prefix %s (%s) with volume %s", pathString, reason, this));
    }
}

