/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

public class DurationFormat {
    private final String str;

    public DurationFormat(long time, String space) {
        String dash = "-";
        if (time == 0L) {
            this.str = dash;
            return;
        }
        long ms = time % 1000L;
        if ((time /= 1000L) == 0L) {
            this.str = String.format("%dms", ms);
            return;
        }
        long sec = time % 60L;
        if ((time /= 60L) == 0L) {
            this.str = String.format("%ds" + space + "%dms", sec, ms);
            return;
        }
        long min = time % 60L;
        if ((time /= 60L) == 0L) {
            this.str = String.format("%dm" + space + "%ds", min, sec);
            return;
        }
        long hr = time % 24L;
        if ((time /= 24L) == 0L) {
            this.str = String.format("%dh" + space + "%dm", hr, min);
            return;
        }
        long day = time % 365L;
        if ((time /= 365L) == 0L) {
            this.str = String.format("%dd" + space + "%dh", day, hr);
            return;
        }
        long yr = time;
        this.str = String.format("%dy" + space + "%dd", yr, day);
    }

    public String toString() {
        return this.str;
    }
}

