/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.trace;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.Objects;

class TraceWrappedRunnable
implements Runnable {
    private final Context context = Context.current();
    private final Runnable unwrapped;

    static Runnable unwrapFully(Runnable r) {
        while (r instanceof TraceWrappedRunnable) {
            r = ((TraceWrappedRunnable)r).unwrapped;
        }
        return r;
    }

    TraceWrappedRunnable(Runnable other) {
        this.unwrapped = TraceWrappedRunnable.unwrapFully(other);
    }

    @Override
    public void run() {
        try (Scope unused = this.context.makeCurrent();){
            this.unwrapped.run();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TraceWrappedRunnable) {
            return Objects.equals(this.unwrapped, ((TraceWrappedRunnable)obj).unwrapped);
        }
        return false;
    }

    public int hashCode() {
        return this.unwrapped.hashCode();
    }
}

