/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.scan;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.core.spi.scan.ScanServerAttempt;
import org.apache.accumulo.core.spi.scan.ScanServerInfo;
import org.apache.accumulo.core.spi.scan.ScanServerSelections;

public interface ScanServerSelector {
    public static final String DEFAULT_SCAN_SERVER_GROUP_NAME = "default";

    default public void init(InitParameters params) {
        Preconditions.checkArgument((boolean)params.getOptions().isEmpty(), (Object)"No options expected");
    }

    public ScanServerSelections selectServers(SelectorParameters var1);

    public static interface InitParameters {
        public Map<String, String> getOptions();

        public ServiceEnvironment getServiceEnv();

        public Supplier<Collection<ScanServerInfo>> getScanServers();
    }

    public static interface SelectorParameters {
        public Collection<TabletId> getTablets();

        public Collection<? extends ScanServerAttempt> getAttempts(TabletId var1);

        public Map<String, String> getHints();

        public <T> Optional<T> waitUntil(Supplier<Optional<T>> var1, Duration var2, String var3);
    }
}

