/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.apache.accumulo.core.client.sample.Sampler;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.blockfile.impl.CachableBlockFile;
import org.apache.accumulo.core.file.rfile.EcEnabled;
import org.apache.accumulo.core.file.rfile.RFile;
import org.apache.accumulo.core.file.rfile.bcfile.BCFile;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.sample.impl.SamplerFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RFileOperations
extends FileOperations {
    private static final Logger LOG = LoggerFactory.getLogger(RFileOperations.class);
    private static final Collection<ByteSequence> EMPTY_CF_SET = Collections.emptySet();

    private static RFile.Reader getReader(FileOperations.FileOptions options) throws IOException {
        CachableBlockFile.CachableBuilder cb = new CachableBlockFile.CachableBuilder().fsPath(options.getFileSystem(), new Path(options.getFilename()), options.dropCacheBehind).conf(options.getConfiguration()).fileLen(options.getFileLenCache()).cacheProvider(options.cacheProvider).readLimiter(options.getRateLimiter()).cryptoService(options.getCryptoService());
        return new RFile.Reader(cb);
    }

    @Override
    protected long getFileSize(FileOperations.FileOptions options) throws IOException {
        return options.getFileSystem().getFileStatus(new Path(options.getFilename())).getLen();
    }

    @Override
    protected FileSKVIterator openIndex(FileOperations.FileOptions options) throws IOException {
        return RFileOperations.getReader(options).getIndex();
    }

    @Override
    protected FileSKVIterator openReader(FileOperations.FileOptions options) throws IOException {
        RFile.Reader reader = RFileOperations.getReader(options);
        if (options.isSeekToBeginning()) {
            reader.seek(new Range((Key)null, null), EMPTY_CF_SET, false);
        }
        return reader;
    }

    @Override
    protected FileSKVIterator openScanReader(FileOperations.FileOptions options) throws IOException {
        RFile.Reader reader = RFileOperations.getReader(options);
        reader.seek(options.getRange(), options.getColumnFamilies(), options.isRangeInclusive());
        return reader;
    }

    @Override
    protected FileSKVWriter openWriter(FileOperations.FileOptions options) throws IOException {
        String compression;
        AccumuloConfiguration acuconf = options.getTableConfiguration();
        long blockSize = acuconf.getAsBytes(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE);
        Preconditions.checkArgument((blockSize < Integer.MAX_VALUE && blockSize > 0L ? 1 : 0) != 0, (Object)"table.file.compress.blocksize must be greater than 0 and less than 2147483647");
        long indexBlockSize = acuconf.getAsBytes(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX);
        Preconditions.checkArgument((indexBlockSize < Integer.MAX_VALUE && indexBlockSize > 0L ? 1 : 0) != 0, (Object)"table.file.compress.blocksize.index must be greater than 0 and less than 2147483647");
        SamplerConfigurationImpl samplerConfig = SamplerConfigurationImpl.newSamplerConfig(acuconf);
        Sampler sampler = null;
        if (samplerConfig != null) {
            sampler = SamplerFactory.newSampler(samplerConfig, acuconf, options.isAccumuloStartEnabled());
        }
        compression = (compression = options.getCompression()) == null ? options.getTableConfiguration().get(Property.TABLE_FILE_COMPRESSION_TYPE) : compression;
        FSDataOutputStream outputStream = options.getOutputStream();
        Configuration conf = options.getConfiguration();
        if (outputStream == null) {
            int hrep = conf.getInt("dfs.replication", 3);
            int trep = acuconf.getCount(Property.TABLE_FILE_REPLICATION);
            int rep = hrep;
            if (trep > 0 && trep != hrep) {
                rep = trep;
            }
            long hblock = conf.getLong("dfs.block.size", 0x4000000L);
            long tblock = acuconf.getAsBytes(Property.TABLE_FILE_BLOCK_SIZE);
            long block = hblock;
            if (tblock > 0L) {
                block = tblock;
            }
            int bufferSize = conf.getInt("io.file.buffer.size", 4096);
            String file = options.getFilename();
            FileSystem fs = options.getFileSystem();
            EcEnabled ecEnable = EcEnabled.valueOf(options.getTableConfiguration().get(Property.TABLE_ENABLE_ERASURE_CODES).toUpperCase());
            if (fs instanceof DistributedFileSystem) {
                DistributedFileSystem.HdfsDataOutputStreamBuilder builder = (DistributedFileSystem.HdfsDataOutputStreamBuilder)((DistributedFileSystem.HdfsDataOutputStreamBuilder)((DistributedFileSystem.HdfsDataOutputStreamBuilder)((DistributedFileSystem)fs).createFile(new Path(file)).bufferSize(bufferSize)).blockSize(block)).overwrite(false);
                if (options.dropCacheBehind) {
                    builder = builder.syncBlock();
                }
                builder = (DistributedFileSystem.HdfsDataOutputStreamBuilder)builder.recursive();
                switch (ecEnable) {
                    case ENABLE: {
                        String ecPolicyName = options.getTableConfiguration().get(Property.TABLE_ERASURE_CODE_POLICY);
                        Preconditions.checkArgument((!ecPolicyName.isBlank() ? 1 : 0) != 0, (String)"Blank or empty value set for %s", (Object)Property.TABLE_ERASURE_CODE_POLICY.getKey());
                        builder = builder.ecPolicyName(ecPolicyName);
                        break;
                    }
                    case DISABLE: {
                        builder = ((DistributedFileSystem.HdfsDataOutputStreamBuilder)builder.replication((short)rep)).replicate();
                        break;
                    }
                    case INHERIT: {
                        builder = (DistributedFileSystem.HdfsDataOutputStreamBuilder)builder.replication((short)rep);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(ecEnable.name());
                    }
                }
                outputStream = builder.build();
            } else if (options.dropCacheBehind) {
                EnumSet<CreateFlag> set = EnumSet.of(CreateFlag.SYNC_BLOCK, CreateFlag.CREATE);
                outputStream = fs.create(new Path(file), FsPermission.getDefault(), set, bufferSize, (short)rep, block, null);
            } else {
                outputStream = fs.create(new Path(file), false, bufferSize, (short)rep, block);
            }
            if (options.dropCacheBehind) {
                try {
                    outputStream.setDropBehind(Boolean.TRUE);
                    LOG.trace("Called setDropBehind(TRUE) for stream writing file {}", (Object)options.filename);
                }
                catch (UnsupportedOperationException e) {
                    LOG.debug("setDropBehind not enabled for file: {}", (Object)options.filename);
                }
                catch (IOException e) {
                    LOG.debug("IOException setting drop behind for file: {}, msg: {}", (Object)options.filename, (Object)e.getMessage());
                }
            }
        }
        BCFile.Writer _cbw = new BCFile.Writer(outputStream, options.getRateLimiter(), compression, conf, options.cryptoService);
        return new RFile.Writer(_cbw, (int)blockSize, (int)indexBlockSize, samplerConfig, sampler);
    }
}

