/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.apache.accumulo.core.data.AbstractId;

public class InstanceId
extends AbstractId<InstanceId> {
    private static final long serialVersionUID = 1L;
    static final Cache<String, InstanceId> cache = CacheBuilder.newBuilder().weakValues().build();

    private InstanceId(String canonical) {
        super(canonical);
    }

    public static InstanceId of(String canonical) {
        try {
            return (InstanceId)cache.get((Object)canonical, () -> new InstanceId(canonical));
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)"This should never happen: ID constructor should never return null.");
        }
    }

    public static InstanceId of(UUID uuid) {
        return InstanceId.of(Objects.requireNonNull(uuid, "uuid cannot be null").toString());
    }
}

