/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.lexicoder;

import org.apache.accumulo.core.client.lexicoder.AbstractLexicoder;
import org.apache.accumulo.core.client.lexicoder.ULongLexicoder;

public class DoubleLexicoder
extends AbstractLexicoder<Double> {
    private final ULongLexicoder longEncoder = new ULongLexicoder();

    @Override
    public byte[] encode(Double d) {
        long l = Double.doubleToRawLongBits(d);
        l = l < 0L ? (l ^= 0xFFFFFFFFFFFFFFFFL) : (l ^= Long.MIN_VALUE);
        return this.longEncoder.encode(l);
    }

    @Override
    public Double decode(byte[] b) {
        return (Double)super.decode(b);
    }

    @Override
    protected Double decodeUnchecked(byte[] data, int offset, int len) {
        long l = this.longEncoder.decodeUnchecked(data, offset, len);
        l = l < 0L ? (l ^= Long.MIN_VALUE) : (l ^= 0xFFFFFFFFFFFFFFFFL);
        return Double.longBitsToDouble(l);
    }
}

