/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.create;

import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.TableInfo;
import org.apache.accumulo.manager.tableOps.create.PopulateZookeeper;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.slf4j.LoggerFactory;

class SetupPermissions
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final TableInfo tableInfo;

    SetupPermissions(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public Repo<Manager> call(long tid, Manager env) throws Exception {
        AuditedSecurityOperation security = env.getContext().getSecurityOperation();
        if (!this.tableInfo.getUser().equals(env.getContext().getCredentials().getPrincipal())) {
            for (TablePermission permission : TablePermission.values()) {
                try {
                    security.grantTablePermission(env.getContext().rpcCreds(), this.tableInfo.getUser(), this.tableInfo.getTableId(), this.tableInfo.getTableName(), permission, this.tableInfo.getNamespaceId());
                }
                catch (ThriftSecurityException e) {
                    LoggerFactory.getLogger(SetupPermissions.class).error("{}", (Object)e.getMessage(), (Object)e);
                    throw e;
                }
            }
        }
        return new PopulateZookeeper(this.tableInfo);
    }

    @Override
    public void undo(long tid, Manager env) throws Exception {
        env.getContext().getSecurityOperation().deleteTable(env.getContext().rpcCreds(), this.tableInfo.getTableId(), this.tableInfo.getNamespaceId());
    }
}

