/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ActiveCompaction;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowOps {
    private static final Logger log = LoggerFactory.getLogger(SlowOps.class);
    private static final String TSERVER_COMPACTION_MAJOR_CONCURRENT_MAX = "tserver.compaction.major.concurrent.max";
    private static final long SLOW_SCAN_SLEEP_MS = 250L;
    private static final int NUM_DATA_ROWS = 1000;
    private final Connector connector;
    private final String tableName;
    private final long maxWait;
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    private Future<?> compactTask = null;

    private SlowOps(Connector connector, String tableName, long maxWait) {
        this.connector = connector;
        this.tableName = tableName;
        this.maxWait = maxWait;
        this.createData();
    }

    public SlowOps(Connector connector, String tableName, long maxWait, int numParallelExpected) {
        this(connector, tableName, maxWait);
        this.setExpectedCompactions(numParallelExpected);
    }

    public void setExpectedCompactions(int numParallelExpected) {
        int target = numParallelExpected + 1;
        try {
            Map sysConfig = this.connector.instanceOperations().getSystemConfiguration();
            int current = Integer.parseInt((String)sysConfig.get(TSERVER_COMPACTION_MAJOR_CONCURRENT_MAX));
            if (current < target) {
                this.connector.instanceOperations().setProperty(TSERVER_COMPACTION_MAJOR_CONCURRENT_MAX, Integer.toString(target));
                sysConfig = this.connector.instanceOperations().getSystemConfiguration();
            }
            Integer.parseInt((String)sysConfig.get(TSERVER_COMPACTION_MAJOR_CONCURRENT_MAX));
        }
        catch (NumberFormatException | AccumuloException | AccumuloSecurityException ex) {
            throw new IllegalStateException("Could not set parallel compaction limit to " + target, ex);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    private void createData() {
        try {
            this.connector.tableOperations().create(this.tableName);
            log.info("Created table id: {}, name '{}'", this.connector.tableOperations().tableIdMap().get(this.tableName), (Object)this.tableName);
            try (BatchWriter bw = this.connector.createBatchWriter(this.tableName, new BatchWriterConfig());){
                for (int i = 0; i < 1000; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%05d", i)));
                    m.put(new Text("col" + (i % 3 + 1)), new Text("qual"), new Value("junk".getBytes(StandardCharsets.UTF_8)));
                    bw.addMutation(m);
                }
            }
            this.verifyRows();
        }
        catch (AccumuloException | AccumuloSecurityException | TableExistsException | TableNotFoundException ex) {
            throw new IllegalStateException("Create data failed with exception", ex);
        }
    }

    private void verifyRows() {
        long startTimestamp = System.nanoTime();
        int count = this.scanCount();
        log.trace("Scan time for {} rows {} ms", (Object)1000, (Object)TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimestamp, TimeUnit.NANOSECONDS));
        if (count != 1000) {
            throw new IllegalStateException(String.format("Number of rows %1$d does not match expected %2$d", count, 1000));
        }
    }

    private int scanCount() {
        int n;
        block10: {
            Scanner scanner = this.connector.createScanner(this.tableName, Authorizations.EMPTY);
            try {
                int count = 0;
                for (Map.Entry elt : scanner) {
                    String expected = String.format("%05d", count);
                    assert (((Key)elt.getKey()).getRow().toString().equals(expected));
                    ++count;
                }
                n = count;
                if (scanner == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (scanner != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TableNotFoundException ex) {
                    log.debug("cannot verify row count, table '{}' does not exist", (Object)this.tableName);
                    throw new IllegalStateException(ex);
                }
            }
            scanner.close();
        }
        return n;
    }

    public void startCompactTask() {
        this.compactTask = pool.submit(new SlowCompactionRunner());
        if (!this.blockUntilCompactionRunning()) {
            throw new IllegalStateException("Compaction could not be started for " + this.tableName);
        }
    }

    private boolean blockUntilCompactionRunning() {
        long startWait = System.currentTimeMillis();
        List tservers = this.connector.instanceOperations().getTabletServers();
        while (System.currentTimeMillis() < startWait + this.maxWait) {
            try {
                ArrayList activeCompactions = new ArrayList();
                for (String tserver : tservers) {
                    List ac = this.connector.instanceOperations().getActiveCompactions(tserver);
                    activeCompactions.addAll(ac);
                    log.trace("tserver {}, running compactions {}", (Object)tservers, (Object)ac.size());
                }
                if (!activeCompactions.isEmpty()) {
                    try {
                        for (ActiveCompaction compaction : activeCompactions) {
                            log.debug("Compaction running for {}", (Object)compaction.getTable());
                            if (compaction.getTable().compareTo(this.tableName) != 0) continue;
                            return true;
                        }
                    }
                    catch (TableNotFoundException ex) {
                        log.trace("Compaction found for unknown table {}", activeCompactions);
                    }
                }
            }
            catch (AccumuloException | AccumuloSecurityException ex) {
                throw new IllegalStateException("failed to get active compactions, test fails.", ex);
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        log.debug("Could not find compaction for {} after {} seconds", (Object)this.tableName, (Object)TimeUnit.MILLISECONDS.toSeconds(this.maxWait));
        return false;
    }

    public boolean blockWhileCompactionRunning() {
        try {
            if (this.compactTask == null) {
                throw new IllegalStateException("Compaction task has not been started - call startCompactionTask() before blocking");
            }
            this.compactTask.get();
            return true;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException ex) {
            return false;
        }
    }

    private class SlowCompactionRunner
    implements Runnable {
        SlowCompactionRunner() {
        }

        @Override
        public void run() {
            long startTimestamp = System.nanoTime();
            IteratorSetting slow = new IteratorSetting(30, "slow", SlowIterator.class);
            SlowIterator.setSleepTime(slow, 250L);
            ArrayList<IteratorSetting> compactIterators = new ArrayList<IteratorSetting>();
            compactIterators.add(slow);
            log.trace("Starting slow operation using iterator: {}", (Object)slow);
            int retry = 0;
            boolean completed = false;
            while (!completed && retry++ < 5) {
                try {
                    log.info("Starting compaction.  Attempt {}", (Object)retry);
                    SlowOps.this.connector.tableOperations().compact(SlowOps.this.tableName, null, null, compactIterators, true, true);
                    completed = true;
                }
                catch (Throwable ex) {
                    if (ex.getMessage().contains("Compaction canceled")) {
                        return;
                    }
                    log.info("Exception thrown while waiting for compaction - will retry", ex);
                    try {
                        Thread.sleep(10000 * retry);
                    }
                    catch (InterruptedException iex) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
            log.debug("Compaction wait is complete");
            log.trace("Slow compaction of {} rows took {} ms", (Object)1000, (Object)TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimestamp, TimeUnit.NANOSECONDS));
            startTimestamp = System.nanoTime();
            int count = SlowOps.this.scanCount();
            log.trace("After compaction, scan time for {} rows {} ms", (Object)1000, (Object)TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimestamp, TimeUnit.NANOSECONDS));
            if (count != 1000) {
                throw new IllegalStateException(String.format("After compaction, number of rows %1$d does not match expected %2$d", count, 1000));
            }
        }
    }
}

