/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.stress.random;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.stress.random.ScanOpts;
import org.apache.hadoop.io.Text;

public class Scan {
    public static void main(String[] args) throws Exception {
        LoopControl scanning_condition;
        ScanOpts opts = new ScanOpts();
        opts.parseArgs(Scan.class.getName(), args, new Object[0]);
        Connector connector = opts.getConnector();
        Scanner scanner = connector.createScanner(opts.getTableName(), new Authorizations());
        if (opts.isolate) {
            scanner.enableIsolation();
        }
        Random tablet_index_generator = new Random(opts.scan_seed);
        LoopControl loopControl = scanning_condition = opts.continuous ? new ContinuousLoopControl() : new IterativeLoopControl(opts.scan_iterations);
        while (scanning_condition.keepScanning()) {
            Range range = Scan.pickRange(connector.tableOperations(), opts.getTableName(), tablet_index_generator);
            scanner.setRange(range);
            if (opts.batch_size > 0) {
                scanner.setBatchSize(opts.batch_size);
            }
            try {
                Scan.consume(scanner);
            }
            catch (Exception e) {
                System.err.println(String.format("Exception while scanning range %s. Check the state of Accumulo for errors.", range));
                throw e;
            }
        }
    }

    public static void consume(Iterable<?> iterable) {
        Iterator<?> itr = iterable.iterator();
        while (itr.hasNext()) {
            itr.next();
        }
    }

    public static Range pickRange(TableOperations tops, String table, Random r) throws TableNotFoundException, AccumuloSecurityException, AccumuloException {
        ArrayList splits = Lists.newArrayList((Iterable)tops.listSplits(table));
        if (splits.isEmpty()) {
            return new Range();
        }
        int index = r.nextInt(splits.size());
        Text endRow = (Text)splits.get(index);
        Text startRow = index == 0 ? null : (Text)splits.get(index - 1);
        return new Range(startRow, false, endRow, true);
    }

    static class ContinuousLoopControl
    implements LoopControl {
        ContinuousLoopControl() {
        }

        @Override
        public boolean keepScanning() {
            return true;
        }
    }

    static class IterativeLoopControl
    implements LoopControl {
        private final int max;
        private int current;

        public IterativeLoopControl(int max) {
            this.max = max;
            this.current = 0;
        }

        @Override
        public boolean keepScanning() {
            if (this.current < this.max) {
                ++this.current;
                return true;
            }
            return false;
        }
    }

    static interface LoopControl {
        public boolean keepScanning();
    }
}

