/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.stress.random;

import com.google.common.base.Preconditions;
import java.util.Random;

public class RandomWithinRange {
    private final Random random;
    private final int min;
    private final int max;

    public RandomWithinRange(int seed, int min, int max) {
        this(new Random(seed), min, max);
    }

    public RandomWithinRange(Random random, int min, int max) {
        Preconditions.checkArgument((min > 0 ? 1 : 0) != 0, (Object)"Min must be positive.");
        Preconditions.checkArgument((max >= min ? 1 : 0) != 0, (Object)"Max must be greater than or equal to min.");
        this.random = random;
        this.min = min;
        this.max = max;
    }

    public int next() {
        if (this.min == this.max) {
            return this.min;
        }
        return this.random.nextInt(this.max - this.min) + this.min;
    }

    public byte[] next_bytes() {
        byte[] b = new byte[this.next()];
        this.random.nextBytes(b);
        return b;
    }
}

