/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.scalability;

import com.beust.jcommander.Parameter;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.test.scalability.ScaleTest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Run {
    private static final Logger log = LoggerFactory.getLogger(Run.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String sitePath = "/tmp/scale-site.conf";
        String testPath = "/tmp/scale-test.conf";
        Opts opts = new Opts();
        opts.parseArgs(Run.class.getName(), args, new Object[0]);
        Configuration conf = CachedConfiguration.getInstance();
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.copyToLocalFile(new Path("/accumulo-scale/conf/site.conf"), new Path("/tmp/scale-site.conf"));
        fs.copyToLocalFile(new Path(String.format("/accumulo-scale/conf/%s.conf", opts.testId)), new Path("/tmp/scale-test.conf"));
        Properties scaleProps = new Properties();
        Properties testProps = new Properties();
        try {
            try (FileInputStream fis = new FileInputStream("/tmp/scale-site.conf");){
                scaleProps.load(fis);
            }
            fis = new FileInputStream("/tmp/scale-test.conf");
            try {
                testProps.load(fis);
            }
            finally {
                fis.close();
            }
        }
        catch (Exception e) {
            log.error("Error loading config file.", (Throwable)e);
        }
        ScaleTest test = (ScaleTest)Class.forName(String.format("org.apache.accumulo.test.scalability.%s", opts.testId)).newInstance();
        test.init(scaleProps, testProps, opts.numTabletServers);
        if (opts.action.equalsIgnoreCase("setup")) {
            test.setup();
        } else if (opts.action.equalsIgnoreCase("client")) {
            InetAddress addr = InetAddress.getLocalHost();
            String host = addr.getHostName();
            fs.createNewFile(new Path("/accumulo-scale/clients/" + host));
            test.client();
            fs.copyFromLocalFile(new Path("/tmp/scale.out"), new Path("/accumulo-scale/results/" + host));
        } else if (opts.action.equalsIgnoreCase("teardown")) {
            test.teardown();
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"--testId"}, required=true)
        String testId;
        @Parameter(names={"--action"}, required=true, description="one of 'setup', 'teardown' or 'client'")
        String action;
        @Parameter(names={"--count"}, description="number of tablet servers", required=true)
        int numTabletServers;

        Opts() {
        }
    }
}

