/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication.merkle;

import com.google.common.collect.Iterables;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.test.replication.merkle.MerkleTreeNode;

public class MerkleTree {
    protected List<MerkleTreeNode> leaves;
    protected String digestAlgorithm;

    public MerkleTree(List<MerkleTreeNode> leaves, String digestAlgorithm) {
        this.leaves = leaves;
        this.digestAlgorithm = digestAlgorithm;
    }

    public MerkleTreeNode getRootNode() throws NoSuchAlgorithmException {
        ArrayList<MerkleTreeNode> buffer = new ArrayList<MerkleTreeNode>(this.leaves.size());
        buffer.addAll(this.leaves);
        while (buffer.size() > 1) {
            Pair<Integer, Integer> pairToJoin = this.findNextPair(buffer);
            MerkleTreeNode parent = new MerkleTreeNode(Arrays.asList(buffer.get((Integer)pairToJoin.getFirst()), buffer.get((Integer)pairToJoin.getSecond())), this.digestAlgorithm);
            buffer.set((Integer)pairToJoin.getFirst(), parent);
            buffer.remove((Integer)pairToJoin.getSecond());
        }
        return (MerkleTreeNode)Iterables.getOnlyElement(buffer);
    }

    protected Pair<Integer, Integer> findNextPair(List<MerkleTreeNode> nodes) {
        int i = 0;
        for (int j = 1; i < nodes.size() && j < nodes.size(); ++i, ++j) {
            MerkleTreeNode left = nodes.get(i);
            MerkleTreeNode right = nodes.get(j);
            if (left.getLevel() == right.getLevel()) {
                return new Pair((Object)i, (Object)j);
            }
            if (j + 1 < nodes.size()) {
                continue;
            }
            return new Pair((Object)i, (Object)j);
        }
        if (2 < nodes.size()) {
            throw new IllegalStateException("Should not have exited loop without pairing two elements when we have at least 3 nodes");
        }
        if (2 == nodes.size()) {
            return new Pair((Object)0, (Object)1);
        }
        throw new IllegalStateException("Must have at least two nodes to pair");
    }
}

