/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.master.replication.WorkMaker;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Replication ITs are not stable and not currently maintained")
public class WorkMakerIT
extends ConfigurableMacBase {
    private Connector conn;

    @Before
    public void setupInstance() throws Exception {
        this.conn = this.getConnector();
        ReplicationTable.setOnline((Connector)this.conn);
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.WRITE);
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.READ);
    }

    @Test
    public void singleUnitSingleTarget() throws Exception {
        String table = this.testName.getMethodName();
        this.conn.tableOperations().create(table);
        String tableId = (String)this.conn.tableOperations().tableIdMap().get(table);
        String file = "hdfs://localhost:8020/accumulo/wal/123456-1234-1234-12345678";
        long timeCreated = System.currentTimeMillis();
        Mutation m = new Mutation((CharSequence)new Path(file).toString());
        m.put(ReplicationSchema.StatusSection.NAME, new Text(tableId), StatusUtil.fileCreatedValue((long)timeCreated));
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        bw.addMutation(m);
        bw.flush();
        Scanner s = ReplicationTable.getScanner((Connector)this.conn);
        ReplicationSchema.StatusSection.limit((ScannerBase)s);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)s));
        MockWorkMaker workMaker = new MockWorkMaker(this.conn);
        ReplicationTarget expected = new ReplicationTarget("remote_cluster_1", "4", tableId);
        workMaker.setBatchWriter(bw);
        workMaker.addWorkRecord(new Text(file), StatusUtil.fileCreatedValue((long)timeCreated), (Map<String, String>)ImmutableMap.of((Object)"remote_cluster_1", (Object)"4"), tableId);
        s = ReplicationTable.getScanner((Connector)this.conn);
        ReplicationSchema.WorkSection.limit((ScannerBase)s);
        Map.Entry workEntry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
        Key workKey = (Key)workEntry.getKey();
        ReplicationTarget actual = ReplicationTarget.from((Text)workKey.getColumnQualifier());
        Assert.assertEquals((Object)file, (Object)workKey.getRow().toString());
        Assert.assertEquals((Object)ReplicationSchema.WorkSection.NAME, (Object)workKey.getColumnFamily());
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals(workEntry.getValue(), (Object)StatusUtil.fileCreatedValue((long)timeCreated));
    }

    @Test
    public void singleUnitMultipleTargets() throws Exception {
        String table = this.testName.getMethodName();
        this.conn.tableOperations().create(table);
        String tableId = (String)this.conn.tableOperations().tableIdMap().get(table);
        String file = "hdfs://localhost:8020/accumulo/wal/123456-1234-1234-12345678";
        Mutation m = new Mutation((CharSequence)new Path(file).toString());
        m.put(ReplicationSchema.StatusSection.NAME, new Text(tableId), StatusUtil.fileCreatedValue((long)System.currentTimeMillis()));
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        bw.addMutation(m);
        bw.flush();
        Scanner s = ReplicationTable.getScanner((Connector)this.conn);
        ReplicationSchema.StatusSection.limit((ScannerBase)s);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)s));
        MockWorkMaker workMaker = new MockWorkMaker(this.conn);
        ImmutableMap targetClusters = ImmutableMap.of((Object)"remote_cluster_1", (Object)"4", (Object)"remote_cluster_2", (Object)"6", (Object)"remote_cluster_3", (Object)"8");
        HashSet<ReplicationTarget> expectedTargets = new HashSet<ReplicationTarget>();
        for (Map.Entry cluster : targetClusters.entrySet()) {
            expectedTargets.add(new ReplicationTarget((String)cluster.getKey(), (String)cluster.getValue(), tableId));
        }
        workMaker.setBatchWriter(bw);
        workMaker.addWorkRecord(new Text(file), StatusUtil.fileCreatedValue((long)System.currentTimeMillis()), (Map<String, String>)targetClusters, tableId);
        s = ReplicationTable.getScanner((Connector)this.conn);
        ReplicationSchema.WorkSection.limit((ScannerBase)s);
        HashSet<ReplicationTarget> actualTargets = new HashSet<ReplicationTarget>();
        for (Map.Entry entry : s) {
            Assert.assertEquals((Object)file, (Object)((Key)entry.getKey()).getRow().toString());
            Assert.assertEquals((Object)ReplicationSchema.WorkSection.NAME, (Object)((Key)entry.getKey()).getColumnFamily());
            ReplicationTarget target = ReplicationTarget.from((Text)((Key)entry.getKey()).getColumnQualifier());
            actualTargets.add(target);
        }
        for (ReplicationTarget expected : expectedTargets) {
            Assert.assertTrue((String)("Did not find expected target: " + expected), (boolean)actualTargets.contains(expected));
            actualTargets.remove(expected);
        }
        Assert.assertTrue((String)("Found extra replication work entries: " + actualTargets), (boolean)actualTargets.isEmpty());
    }

    @Test
    public void dontCreateWorkForEntriesWithNothingToReplicate() throws Exception {
        String table = this.testName.getMethodName();
        this.conn.tableOperations().create(table);
        String tableId = (String)this.conn.tableOperations().tableIdMap().get(table);
        String file = "hdfs://localhost:8020/accumulo/wal/123456-1234-1234-12345678";
        Mutation m = new Mutation((CharSequence)new Path(file).toString());
        m.put(ReplicationSchema.StatusSection.NAME, new Text(tableId), StatusUtil.fileCreatedValue((long)System.currentTimeMillis()));
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        bw.addMutation(m);
        bw.flush();
        Scanner s = ReplicationTable.getScanner((Connector)this.conn);
        ReplicationSchema.StatusSection.limit((ScannerBase)s);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)s));
        MockWorkMaker workMaker = new MockWorkMaker(this.conn);
        this.conn.tableOperations().setProperty("accumulo.replication", Property.TABLE_REPLICATION_TARGET.getKey() + "remote_cluster_1", "4");
        workMaker.setBatchWriter(bw);
        workMaker.run();
        s = ReplicationTable.getScanner((Connector)this.conn);
        ReplicationSchema.WorkSection.limit((ScannerBase)s);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)s));
    }

    private static class MockWorkMaker
    extends WorkMaker {
        public MockWorkMaker(Connector conn) {
            super(null, conn);
        }

        public void setBatchWriter(BatchWriter bw) {
            super.setBatchWriter(bw);
        }

        public void addWorkRecord(Text file, Value v, Map<String, String> targets, String sourceTableId) {
            super.addWorkRecord(file, v, targets, sourceTableId);
        }

        public boolean shouldCreateWork(Replication.Status status) {
            return super.shouldCreateWork(status);
        }
    }
}

