/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterators;
import com.google.protobuf.GeneratedMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.master.replication.UnorderedWorkAssigner;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.replication.AccumuloReplicaSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="Replication ITs are not stable and not currently maintained")
public class UnorderedWorkAssignerReplicationIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(UnorderedWorkAssignerReplicationIT.class);
    private ExecutorService executor;
    private int timeoutFactor = 1;

    @Before
    public void createExecutor() {
        this.executor = Executors.newSingleThreadExecutor();
        try {
            this.timeoutFactor = Integer.parseInt(System.getProperty("timeout.factor"));
        }
        catch (NumberFormatException exception) {
            log.warn("Could not parse timeout.factor, not increasing timeout.");
        }
        Assert.assertTrue((String)"The timeout factor must be a positive, non-zero value", (this.timeoutFactor > 0 ? 1 : 0) != 0);
    }

    @After
    public void stopExecutor() {
        if (null != this.executor) {
            this.executor.shutdownNow();
        }
    }

    @Override
    public int defaultTimeoutSeconds() {
        return 300;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.TSERV_WALOG_MAX_SIZE, "2M");
        cfg.setProperty(Property.GC_CYCLE_START, "1s");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "5s");
        cfg.setProperty(Property.REPLICATION_WORK_ASSIGNMENT_SLEEP, "1s");
        cfg.setProperty(Property.MASTER_REPLICATION_SCAN_INTERVAL, "1s");
        cfg.setProperty(Property.REPLICATION_MAX_UNIT_SIZE, "8M");
        cfg.setProperty(Property.REPLICATION_NAME, "master");
        cfg.setProperty(Property.REPLICATION_WORK_ASSIGNER, UnorderedWorkAssigner.class.getName());
        cfg.setProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX, "1M");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    private void updatePeerConfigFromPrimary(MiniAccumuloConfigImpl primaryCfg, MiniAccumuloConfigImpl peerCfg) {
        String credProvider;
        Map primarySiteConfig = primaryCfg.getSiteConfig();
        if ("true".equals(primarySiteConfig.get(Property.INSTANCE_RPC_SSL_ENABLED.getKey()))) {
            String truststorePassword;
            HashMap<String, String> peerSiteConfig = new HashMap<String, String>();
            peerSiteConfig.put(Property.INSTANCE_RPC_SSL_ENABLED.getKey(), "true");
            String keystorePath = (String)primarySiteConfig.get(Property.RPC_SSL_KEYSTORE_PATH.getKey());
            Assert.assertNotNull((String)"Keystore Path was null", (Object)keystorePath);
            peerSiteConfig.put(Property.RPC_SSL_KEYSTORE_PATH.getKey(), keystorePath);
            String truststorePath = (String)primarySiteConfig.get(Property.RPC_SSL_TRUSTSTORE_PATH.getKey());
            Assert.assertNotNull((String)"Truststore Path was null", (Object)truststorePath);
            peerSiteConfig.put(Property.RPC_SSL_TRUSTSTORE_PATH.getKey(), truststorePath);
            String keystorePassword = (String)primarySiteConfig.get(Property.RPC_SSL_KEYSTORE_PASSWORD.getKey());
            if (null != keystorePassword) {
                peerSiteConfig.put(Property.RPC_SSL_KEYSTORE_PASSWORD.getKey(), keystorePassword);
            }
            if (null != (truststorePassword = (String)primarySiteConfig.get(Property.RPC_SSL_TRUSTSTORE_PASSWORD.getKey()))) {
                peerSiteConfig.put(Property.RPC_SSL_TRUSTSTORE_PASSWORD.getKey(), truststorePassword);
            }
            System.out.println("Setting site configuration for peer " + peerSiteConfig);
            peerCfg.setSiteConfig(peerSiteConfig);
        }
        if (null != (credProvider = (String)primarySiteConfig.get(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey()))) {
            Map peerSiteConfig = peerCfg.getSiteConfig();
            peerSiteConfig.put(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey(), credProvider);
            peerCfg.setSiteConfig(peerSiteConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataWasReplicatedToThePeer() throws Exception {
        MiniAccumuloConfigImpl peerCfg = new MiniAccumuloConfigImpl(UnorderedWorkAssignerReplicationIT.createTestDir(this.getClass().getName() + "_" + this.testName.getMethodName() + "_peer"), "testRootPassword1");
        peerCfg.setNumTservers(1);
        peerCfg.setInstanceName("peer");
        this.updatePeerConfigFromPrimary(this.getCluster().getConfig(), peerCfg);
        peerCfg.setProperty(Property.REPLICATION_NAME, "peer");
        MiniAccumuloClusterImpl peerCluster = new MiniAccumuloClusterImpl(peerCfg);
        peerCluster.start();
        try {
            final Connector connMaster = this.getConnector();
            Connector connPeer = peerCluster.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
            ReplicationTable.setOnline((Connector)connMaster);
            String peerUserName = "peer";
            String peerPassword = "foo";
            String peerClusterName = "peer";
            connPeer.securityOperations().createLocalUser(peerUserName, new PasswordToken((CharSequence)peerPassword));
            connMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_USER.getKey() + peerClusterName, peerUserName);
            connMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_PASSWORD.getKey() + peerClusterName, peerPassword);
            connMaster.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + peerClusterName, ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)AccumuloReplicaSystem.buildConfiguration((String)peerCluster.getInstanceName(), (String)peerCluster.getZooKeepers())));
            String masterTable = "master";
            String peerTable = "peer";
            connMaster.tableOperations().create("master");
            String masterTableId = (String)connMaster.tableOperations().tableIdMap().get("master");
            Assert.assertNotNull((Object)masterTableId);
            connPeer.tableOperations().create("peer");
            String peerTableId = (String)connPeer.tableOperations().tableIdMap().get("peer");
            Assert.assertNotNull((Object)peerTableId);
            connPeer.securityOperations().grantTablePermission(peerUserName, "peer", TablePermission.WRITE);
            connMaster.tableOperations().setProperty("master", Property.TABLE_REPLICATION.getKey(), "true");
            connMaster.tableOperations().setProperty("master", Property.TABLE_REPLICATION_TARGET.getKey() + peerClusterName, peerTableId);
            UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
            BatchWriter bw = connMaster.createBatchWriter("master", new BatchWriterConfig());
            for (int rows = 0; rows < 5000; ++rows) {
                Mutation m = new Mutation((CharSequence)Integer.toString(rows));
                for (int cols = 0; cols < 100; ++cols) {
                    String value = Integer.toString(cols);
                    m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
                }
                bw.addMutation(m);
            }
            bw.close();
            log.info("Wrote all data to master cluster");
            final Set filesNeedingReplication = connMaster.replicationOperations().referencedFiles("master");
            for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
                this.cluster.killProcess(ServerType.TABLET_SERVER, proc);
            }
            this.cluster.exec(TabletServer.class, new String[0]);
            log.info("TabletServer restarted");
            Iterators.size((Iterator)ReplicationTable.getScanner((Connector)connMaster).iterator());
            log.info("TabletServer is online");
            log.info("");
            log.info("Fetching metadata records:");
            try (Scanner s = connMaster.createScanner("accumulo.metadata", Authorizations.EMPTY);){
                for (Map.Entry kv : s) {
                    if (MetadataSchema.ReplicationSection.COLF.equals((Object)((Key)kv.getKey()).getColumnFamily())) {
                        log.info(((Key)kv.getKey()).toStringNoTruncate() + " " + ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)kv.getValue()).get())));
                        continue;
                    }
                    log.info(((Key)kv.getKey()).toStringNoTruncate() + " " + kv.getValue());
                }
            }
            log.info("");
            log.info("Fetching replication records:");
            s = ReplicationTable.getScanner((Connector)connMaster);
            try {
                for (Map.Entry kv : s) {
                    log.info(((Key)kv.getKey()).toStringNoTruncate() + " " + ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)kv.getValue()).get())));
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
            Future<Boolean> future = this.executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    connMaster.replicationOperations().drain("master", filesNeedingReplication);
                    log.info("Drain completed");
                    return true;
                }
            });
            long timeoutSeconds = this.timeoutFactor * 30;
            try {
                future.get(timeoutSeconds, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                future.cancel(true);
                Assert.fail((String)("Drain did not finish within " + timeoutSeconds + " seconds"));
            }
            log.info("drain completed");
            log.info("");
            log.info("Fetching metadata records:");
            try (Scanner s = connMaster.createScanner("accumulo.metadata", Authorizations.EMPTY);){
                for (Map.Entry kv : s) {
                    if (MetadataSchema.ReplicationSection.COLF.equals((Object)((Key)kv.getKey()).getColumnFamily())) {
                        log.info(((Key)kv.getKey()).toStringNoTruncate() + " " + ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)kv.getValue()).get())));
                        continue;
                    }
                    log.info(((Key)kv.getKey()).toStringNoTruncate() + " " + kv.getValue());
                }
            }
            log.info("");
            log.info("Fetching replication records:");
            s = ReplicationTable.getScanner((Connector)connMaster);
            try {
                for (Map.Entry kv : s) {
                    log.info(((Key)kv.getKey()).toStringNoTruncate() + " " + ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)kv.getValue()).get())));
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
            Scanner master = connMaster.createScanner("master", Authorizations.EMPTY);
            Scanner peer = connPeer.createScanner("peer", Authorizations.EMPTY);
            Iterator masterIter = master.iterator();
            Iterator peerIter = peer.iterator();
            Map.Entry masterEntry = null;
            Map.Entry peerEntry = null;
            while (masterIter.hasNext() && peerIter.hasNext()) {
                masterEntry = (Map.Entry)masterIter.next();
                peerEntry = (Map.Entry)peerIter.next();
                Assert.assertEquals((String)(masterEntry.getKey() + " was not equal to " + peerEntry.getKey()), (long)0L, (long)((Key)masterEntry.getKey()).compareTo((Key)peerEntry.getKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS));
                Assert.assertEquals(masterEntry.getValue(), peerEntry.getValue());
            }
            log.info("Last master entry: " + masterEntry);
            log.info("Last peer entry: " + peerEntry);
            Assert.assertFalse((String)"Had more data to read from the master", (boolean)masterIter.hasNext());
            Assert.assertFalse((String)"Had more data to read from the peer", (boolean)peerIter.hasNext());
        }
        finally {
            peerCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataReplicatedToCorrectTable() throws Exception {
        MiniAccumuloConfigImpl peerCfg = new MiniAccumuloConfigImpl(UnorderedWorkAssignerReplicationIT.createTestDir(this.getClass().getName() + "_" + this.testName.getMethodName() + "_peer"), "testRootPassword1");
        peerCfg.setNumTservers(1);
        peerCfg.setInstanceName("peer");
        this.updatePeerConfigFromPrimary(this.getCluster().getConfig(), peerCfg);
        peerCfg.setProperty(Property.REPLICATION_NAME, "peer");
        MiniAccumuloClusterImpl peer1Cluster = new MiniAccumuloClusterImpl(peerCfg);
        peer1Cluster.start();
        try {
            int i;
            Connector connMaster = this.getConnector();
            Connector connPeer = peer1Cluster.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
            String peerClusterName = "peer";
            String peerUserName = "peer";
            String peerPassword = "foo";
            connPeer.securityOperations().createLocalUser(peerUserName, new PasswordToken((CharSequence)peerPassword));
            connMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_USER.getKey() + peerClusterName, peerUserName);
            connMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_PASSWORD.getKey() + peerClusterName, peerPassword);
            connMaster.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + peerClusterName, ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)AccumuloReplicaSystem.buildConfiguration((String)peer1Cluster.getInstanceName(), (String)peer1Cluster.getZooKeepers())));
            String masterTable1 = "master1";
            String peerTable1 = "peer1";
            String masterTable2 = "master2";
            String peerTable2 = "peer2";
            connMaster.tableOperations().create(masterTable1);
            String masterTableId1 = (String)connMaster.tableOperations().tableIdMap().get(masterTable1);
            Assert.assertNotNull((Object)masterTableId1);
            connMaster.tableOperations().create(masterTable2);
            String masterTableId2 = (String)connMaster.tableOperations().tableIdMap().get(masterTable2);
            Assert.assertNotNull((Object)masterTableId2);
            connPeer.tableOperations().create(peerTable1);
            String peerTableId1 = (String)connPeer.tableOperations().tableIdMap().get(peerTable1);
            Assert.assertNotNull((Object)peerTableId1);
            connPeer.tableOperations().create(peerTable2);
            String peerTableId2 = (String)connPeer.tableOperations().tableIdMap().get(peerTable2);
            Assert.assertNotNull((Object)peerTableId2);
            connPeer.securityOperations().grantTablePermission(peerUserName, peerTable1, TablePermission.WRITE);
            connPeer.securityOperations().grantTablePermission(peerUserName, peerTable2, TablePermission.WRITE);
            connMaster.tableOperations().setProperty(masterTable1, Property.TABLE_REPLICATION.getKey(), "true");
            connMaster.tableOperations().setProperty(masterTable1, Property.TABLE_REPLICATION_TARGET.getKey() + peerClusterName, peerTableId1);
            connMaster.tableOperations().setProperty(masterTable2, Property.TABLE_REPLICATION.getKey(), "true");
            connMaster.tableOperations().setProperty(masterTable2, Property.TABLE_REPLICATION_TARGET.getKey() + peerClusterName, peerTableId2);
            UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
            BatchWriter bw = connMaster.createBatchWriter(masterTable1, new BatchWriterConfig());
            long masterTable1Records = 0L;
            for (int rows = 0; rows < 2500; ++rows) {
                Mutation m = new Mutation((CharSequence)(masterTable1 + rows));
                for (int cols = 0; cols < 100; ++cols) {
                    String value = Integer.toString(cols);
                    m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
                    ++masterTable1Records;
                }
                bw.addMutation(m);
            }
            bw.close();
            bw = connMaster.createBatchWriter(masterTable2, new BatchWriterConfig());
            long masterTable2Records = 0L;
            for (int rows = 0; rows < 2500; ++rows) {
                Mutation m = new Mutation((CharSequence)(masterTable2 + rows));
                for (int cols = 0; cols < 100; ++cols) {
                    String value = Integer.toString(cols);
                    m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
                    ++masterTable2Records;
                }
                bw.addMutation(m);
            }
            bw.close();
            log.info("Wrote all data to master cluster");
            Set filesFor1 = connMaster.replicationOperations().referencedFiles(masterTable1);
            Set filesFor2 = connMaster.replicationOperations().referencedFiles(masterTable2);
            while (!ReplicationTable.isOnline((Connector)connMaster)) {
                Thread.sleep(500L);
            }
            for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
                this.cluster.killProcess(ServerType.TABLET_SERVER, proc);
            }
            this.cluster.exec(TabletServer.class, new String[0]);
            log.info("Restarted the tserver");
            Iterators.size((Iterator)connMaster.createScanner(masterTable1, Authorizations.EMPTY).iterator());
            log.info("Waiting for {} for {}", (Object)filesFor1, (Object)masterTable1);
            connMaster.replicationOperations().drain(masterTable1, filesFor1);
            log.info("Waiting for {} for {}", (Object)filesFor2, (Object)masterTable2);
            connMaster.replicationOperations().drain(masterTable2, filesFor2);
            long countTable = 0L;
            for (i = 0; i < 5; ++i) {
                countTable = 0L;
                for (Map.Entry entry : connPeer.createScanner(peerTable1, Authorizations.EMPTY)) {
                    ++countTable;
                    Assert.assertTrue((String)("Found unexpected key-value" + ((Key)entry.getKey()).toStringNoTruncate() + " " + entry.getValue()), (boolean)((Key)entry.getKey()).getRow().toString().startsWith(masterTable1));
                }
                log.info("Found {} records in {}", (Object)countTable, (Object)peerTable1);
                if (masterTable1Records == countTable) continue;
                log.warn("Did not find {} expected records in {}, only found {}", new Object[]{masterTable1Records, peerTable1, countTable});
            }
            Assert.assertEquals((long)masterTable1Records, (long)countTable);
            for (i = 0; i < 5; ++i) {
                countTable = 0L;
                for (Map.Entry entry : connPeer.createScanner(peerTable2, Authorizations.EMPTY)) {
                    ++countTable;
                    Assert.assertTrue((String)("Found unexpected key-value" + ((Key)entry.getKey()).toStringNoTruncate() + " " + entry.getValue()), (boolean)((Key)entry.getKey()).getRow().toString().startsWith(masterTable2));
                }
                log.info("Found {} records in {}", (Object)countTable, (Object)peerTable2);
                if (masterTable2Records == countTable) continue;
                log.warn("Did not find {} expected records in {}, only found {}", new Object[]{masterTable2Records, peerTable2, countTable});
            }
            Assert.assertEquals((long)masterTable2Records, (long)countTable);
        }
        finally {
            peer1Cluster.stop();
        }
    }

    @Test
    public void dataWasReplicatedToThePeerWithoutDrain() throws Exception {
        MiniAccumuloConfigImpl peerCfg = new MiniAccumuloConfigImpl(UnorderedWorkAssignerReplicationIT.createTestDir(this.getClass().getName() + "_" + this.testName.getMethodName() + "_peer"), "testRootPassword1");
        peerCfg.setNumTservers(1);
        peerCfg.setInstanceName("peer");
        this.updatePeerConfigFromPrimary(this.getCluster().getConfig(), peerCfg);
        peerCfg.setProperty(Property.REPLICATION_NAME, "peer");
        MiniAccumuloClusterImpl peerCluster = new MiniAccumuloClusterImpl(peerCfg);
        peerCluster.start();
        Connector connMaster = this.getConnector();
        Connector connPeer = peerCluster.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
        String peerUserName = "repl";
        String peerPassword = "passwd";
        connPeer.securityOperations().createLocalUser(peerUserName, new PasswordToken((CharSequence)peerPassword));
        String peerClusterName = "peer";
        connMaster.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + peerClusterName, ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)AccumuloReplicaSystem.buildConfiguration((String)peerCluster.getInstanceName(), (String)peerCluster.getZooKeepers())));
        connMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_USER.getKey() + peerClusterName, peerUserName);
        connMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_PASSWORD.getKey() + peerClusterName, peerPassword);
        String masterTable = "master";
        String peerTable = "peer";
        connMaster.tableOperations().create(masterTable);
        String masterTableId = (String)connMaster.tableOperations().tableIdMap().get(masterTable);
        Assert.assertNotNull((Object)masterTableId);
        connPeer.tableOperations().create(peerTable);
        String peerTableId = (String)connPeer.tableOperations().tableIdMap().get(peerTable);
        Assert.assertNotNull((Object)peerTableId);
        connPeer.securityOperations().grantTablePermission(peerUserName, peerTable, TablePermission.WRITE);
        connMaster.tableOperations().setProperty(masterTable, Property.TABLE_REPLICATION.getKey(), "true");
        connMaster.tableOperations().setProperty(masterTable, Property.TABLE_REPLICATION_TARGET.getKey() + peerClusterName, peerTableId);
        BatchWriter bw = connMaster.createBatchWriter(masterTable, new BatchWriterConfig());
        for (int rows = 0; rows < 5000; ++rows) {
            Mutation m = new Mutation((CharSequence)Integer.toString(rows));
            for (int cols = 0; cols < 100; ++cols) {
                String value = Integer.toString(cols);
                m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
            }
            bw.addMutation(m);
        }
        bw.close();
        log.info("Wrote all data to master cluster");
        Set files = connMaster.replicationOperations().referencedFiles(masterTable);
        for (String s : files) {
            log.info("Found referenced file for " + masterTable + ": " + s);
        }
        for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
            this.cluster.killProcess(ServerType.TABLET_SERVER, proc);
        }
        this.cluster.exec(TabletServer.class, new String[0]);
        Iterators.size((Iterator)connMaster.createScanner(masterTable, Authorizations.EMPTY).iterator());
        try (Scanner s = connMaster.createScanner("accumulo.replication", Authorizations.EMPTY);){
            for (Map.Entry kv : s) {
                log.debug(((Key)kv.getKey()).toStringNoTruncate() + " " + ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)kv.getValue()).get())));
            }
        }
        connMaster.replicationOperations().drain(masterTable, files);
        Scanner master = connMaster.createScanner(masterTable, Authorizations.EMPTY);
        Scanner peer = connPeer.createScanner(peerTable, Authorizations.EMPTY);
        Iterator masterIter = master.iterator();
        Iterator peerIter = peer.iterator();
        Assert.assertTrue((String)"No data in master table", (boolean)masterIter.hasNext());
        Assert.assertTrue((String)"No data in peer table", (boolean)peerIter.hasNext());
        while (masterIter.hasNext() && peerIter.hasNext()) {
            Map.Entry masterEntry = (Map.Entry)masterIter.next();
            Map.Entry peerEntry = (Map.Entry)peerIter.next();
            Assert.assertEquals((String)(peerEntry.getKey() + " was not equal to " + peerEntry.getKey()), (long)0L, (long)((Key)masterEntry.getKey()).compareTo((Key)peerEntry.getKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS));
            Assert.assertEquals(masterEntry.getValue(), peerEntry.getValue());
        }
        Assert.assertFalse((String)"Had more data to read from the master", (boolean)masterIter.hasNext());
        Assert.assertFalse((String)"Had more data to read from the peer", (boolean)peerIter.hasNext());
        peerCluster.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataReplicatedToCorrectTableWithoutDrain() throws Exception {
        MiniAccumuloConfigImpl peerCfg = new MiniAccumuloConfigImpl(UnorderedWorkAssignerReplicationIT.createTestDir(this.getClass().getName() + "_" + this.testName.getMethodName() + "_peer"), "testRootPassword1");
        peerCfg.setNumTservers(1);
        peerCfg.setInstanceName("peer");
        this.updatePeerConfigFromPrimary(this.getCluster().getConfig(), peerCfg);
        peerCfg.setProperty(Property.REPLICATION_NAME, "peer");
        MiniAccumuloClusterImpl peer1Cluster = new MiniAccumuloClusterImpl(peerCfg);
        peer1Cluster.start();
        try {
            int i;
            Object value;
            int cols;
            Mutation m;
            int rows;
            Connector connMaster = this.getConnector();
            Connector connPeer = peer1Cluster.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
            String peerClusterName = "peer";
            String peerUserName = "repl";
            String peerPassword = "passwd";
            connPeer.securityOperations().createLocalUser(peerUserName, new PasswordToken((CharSequence)peerPassword));
            connMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_USER.getKey() + peerClusterName, peerUserName);
            connMaster.instanceOperations().setProperty(Property.REPLICATION_PEER_PASSWORD.getKey() + peerClusterName, peerPassword);
            connMaster.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + peerClusterName, ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)AccumuloReplicaSystem.buildConfiguration((String)peer1Cluster.getInstanceName(), (String)peer1Cluster.getZooKeepers())));
            String masterTable1 = "master1";
            String peerTable1 = "peer1";
            String masterTable2 = "master2";
            String peerTable2 = "peer2";
            connMaster.tableOperations().create(masterTable1);
            String masterTableId1 = (String)connMaster.tableOperations().tableIdMap().get(masterTable1);
            Assert.assertNotNull((Object)masterTableId1);
            connMaster.tableOperations().create(masterTable2);
            String masterTableId2 = (String)connMaster.tableOperations().tableIdMap().get(masterTable2);
            Assert.assertNotNull((Object)masterTableId2);
            connPeer.tableOperations().create(peerTable1);
            String peerTableId1 = (String)connPeer.tableOperations().tableIdMap().get(peerTable1);
            Assert.assertNotNull((Object)peerTableId1);
            connPeer.tableOperations().create(peerTable2);
            String peerTableId2 = (String)connPeer.tableOperations().tableIdMap().get(peerTable2);
            Assert.assertNotNull((Object)peerTableId2);
            connPeer.securityOperations().grantTablePermission(peerUserName, peerTable1, TablePermission.WRITE);
            connPeer.securityOperations().grantTablePermission(peerUserName, peerTable2, TablePermission.WRITE);
            connMaster.tableOperations().setProperty(masterTable1, Property.TABLE_REPLICATION.getKey(), "true");
            connMaster.tableOperations().setProperty(masterTable1, Property.TABLE_REPLICATION_TARGET.getKey() + peerClusterName, peerTableId1);
            connMaster.tableOperations().setProperty(masterTable2, Property.TABLE_REPLICATION.getKey(), "true");
            connMaster.tableOperations().setProperty(masterTable2, Property.TABLE_REPLICATION_TARGET.getKey() + peerClusterName, peerTableId2);
            UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
            BatchWriter bw = connMaster.createBatchWriter(masterTable1, new BatchWriterConfig());
            for (rows = 0; rows < 2500; ++rows) {
                m = new Mutation((CharSequence)(masterTable1 + rows));
                for (cols = 0; cols < 100; ++cols) {
                    value = Integer.toString(cols);
                    m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
                }
                bw.addMutation(m);
            }
            bw.close();
            bw = connMaster.createBatchWriter(masterTable2, new BatchWriterConfig());
            for (rows = 0; rows < 2500; ++rows) {
                m = new Mutation((CharSequence)(masterTable2 + rows));
                for (cols = 0; cols < 100; ++cols) {
                    value = Integer.toString(cols);
                    m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
                }
                bw.addMutation(m);
            }
            bw.close();
            log.info("Wrote all data to master cluster");
            while (!ReplicationTable.isOnline((Connector)connMaster)) {
                Thread.sleep(500L);
            }
            for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
                this.cluster.killProcess(ServerType.TABLET_SERVER, proc);
            }
            this.cluster.exec(TabletServer.class, new String[0]);
            boolean fullyReplicated = false;
            for (int i2 = 0; i2 < 10 && !fullyReplicated; ++i2) {
                UtilWaitThread.sleepUninterruptibly((long)(this.timeoutFactor * 2), (TimeUnit)TimeUnit.SECONDS);
                Scanner s = ReplicationTable.getScanner((Connector)connMaster);
                ReplicationSchema.WorkSection.limit((ScannerBase)s);
                for (Map.Entry entry : s) {
                    Replication.Status status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                    if (!StatusUtil.isFullyReplicated((Replication.Status)status)) continue;
                    fullyReplicated |= true;
                }
            }
            Assert.assertNotEquals((Object)0, (Object)fullyReplicated);
            long countTable = 0L;
            for (i = 0; i < 10; ++i) {
                countTable = 0L;
                for (Map.Entry entry : connPeer.createScanner(peerTable1, Authorizations.EMPTY)) {
                    ++countTable;
                    Assert.assertTrue((String)("Found unexpected key-value" + ((Key)entry.getKey()).toStringNoTruncate() + " " + entry.getValue()), (boolean)((Key)entry.getKey()).getRow().toString().startsWith(masterTable1));
                }
                log.info("Found {} records in {}", (Object)countTable, (Object)peerTable1);
                if (0L < countTable) break;
                Thread.sleep(2000L);
            }
            Assert.assertTrue((String)("Did not find any records in " + peerTable1 + " on peer"), (countTable > 0L ? 1 : 0) != 0);
            for (i = 0; i < 10; ++i) {
                countTable = 0L;
                for (Map.Entry entry : connPeer.createScanner(peerTable2, Authorizations.EMPTY)) {
                    ++countTable;
                    Assert.assertTrue((String)("Found unexpected key-value" + ((Key)entry.getKey()).toStringNoTruncate() + " " + entry.getValue()), (boolean)((Key)entry.getKey()).getRow().toString().startsWith(masterTable2));
                }
                log.info("Found {} records in {}", (Object)countTable, (Object)peerTable2);
                if (0L < countTable) break;
                Thread.sleep(2000L);
            }
            Assert.assertTrue((String)("Did not find any records in " + peerTable2 + " on peer"), (countTable > 0L ? 1 : 0) != 0);
        }
        finally {
            peer1Cluster.stop();
        }
    }
}

