/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.shard;

import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.shard.Insert;
import org.apache.accumulo.test.randomwalk.shard.ShardFixture;

public class Reindex
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        String indexTableName = (String)state.get("indexTableName");
        String tmpIndexTableName = indexTableName + "_tmp";
        String docTableName = (String)state.get("docTableName");
        int numPartitions = (Integer)state.get("numPartitions");
        Random rand = (Random)state.get("rand");
        ShardFixture.createIndexTable(this.log, state, env, "_tmp", rand);
        Scanner scanner = env.getConnector().createScanner(docTableName, Authorizations.EMPTY);
        BatchWriter tbw = env.getConnector().createBatchWriter(tmpIndexTableName, new BatchWriterConfig());
        int count = 0;
        for (Map.Entry entry : scanner) {
            String docID = ((Key)entry.getKey()).getRow().toString();
            String doc = ((Value)entry.getValue()).toString();
            Insert.indexDocument(tbw, doc, docID, numPartitions);
            ++count;
        }
        tbw.close();
        this.log.debug((Object)("Reindexed " + count + " documents into " + tmpIndexTableName));
    }
}

