/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.sequential;

import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.hadoop.io.Text;

public class Write
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        BatchWriter bw = env.getMultiTableBatchWriter().getBatchWriter(state.getString("seqTableName"));
        state.set("numWrites", state.getLong("numWrites") + 1L);
        Long totalWrites = state.getLong("totalWrites") + 1L;
        if (totalWrites % 10000L == 0L) {
            this.log.debug((Object)("Total writes: " + totalWrites));
        }
        state.set("totalWrites", totalWrites);
        Mutation m = new Mutation(new Text(String.format("%010d", totalWrites)));
        m.put(new Text("cf"), new Text("cq"), new Value("val".getBytes(StandardCharsets.UTF_8)));
        bw.addMutation(m);
    }
}

