/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class DropUser
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getInstance().getConnector(WalkingSecurity.get(state, env).getSysUserName(), WalkingSecurity.get(state, env).getSysToken());
        String tableUserName = WalkingSecurity.get(state, env).getTabUserName();
        boolean exists = WalkingSecurity.get(state, env).userExists(tableUserName);
        boolean hasPermission = WalkingSecurity.get(state, env).canDropUser(WalkingSecurity.get(state, env).getSysCredentials(), tableUserName);
        try {
            conn.securityOperations().dropLocalUser(tableUserName);
        }
        catch (AccumuloSecurityException ae) {
            switch (ae.getSecurityErrorCode()) {
                case PERMISSION_DENIED: {
                    if (hasPermission) {
                        throw new AccumuloException("Got a security exception when I should have had permission.", (Throwable)ae);
                    }
                    if (exists) {
                        env.getConnector().securityOperations().dropLocalUser(tableUserName);
                        WalkingSecurity.get(state, env).dropUser(tableUserName);
                    }
                    return;
                }
                case USER_DOESNT_EXIST: {
                    if (exists) {
                        throw new AccumuloException("Got user DNE exception when user should exists.", (Throwable)ae);
                    }
                    return;
                }
            }
            throw new AccumuloException("Got unexpected exception", (Throwable)ae);
        }
        WalkingSecurity.get(state, env).dropUser(tableUserName);
        Thread.sleep(1000L);
        if (!hasPermission) {
            throw new AccumuloException("Didn't get Security Exception when we should have");
        }
    }
}

