/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.master.state.SetGoalState;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class StartAll
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        this.log.info((Object)"Starting all servers");
        SetGoalState.main((String[])new String[]{MasterGoalState.NORMAL.name()});
        Process exec = Runtime.getRuntime().exec(new String[]{System.getenv().get("ACCUMULO_HOME") + "/bin/start-all.sh"});
        exec.waitFor();
        while (true) {
            try {
                MasterMonitorInfo masterStats;
                do {
                    AccumuloServerContext context = new AccumuloServerContext(new ServerConfigurationFactory(HdfsZooInstance.getInstance()));
                    MasterClientService.Client client = MasterClient.getConnection((ClientContext)context);
                    masterStats = client.getMasterStats(Tracer.traceInfo(), context.rpcCreds());
                } while (masterStats.tServerInfo.isEmpty());
            }
            catch (Exception ex) {
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
    }
}

