/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.proxy;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.proxy.Proxy;
import org.apache.accumulo.proxy.thrift.ColumnUpdate;
import org.apache.accumulo.proxy.thrift.TimeType;
import org.apache.accumulo.test.proxy.TestProxyClient;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestProxyTableOperations {
    protected static TServer proxy;
    protected static TestProxyClient tpc;
    protected static ByteBuffer userpass;
    protected static final int port = 10195;
    protected static final String testtable = "testtable";

    @BeforeClass
    public static void setup() throws Exception {
        Properties prop = new Properties();
        prop.setProperty("useMockInstance", "true");
        prop.put("tokenClass", PasswordToken.class.getName());
        proxy = Proxy.createProxyServer((HostAndPort)HostAndPort.fromParts((String)"localhost", (int)10195), (TProtocolFactory)new TCompactProtocol.Factory(), (Properties)prop).server;
        while (!proxy.isServing()) {
            Thread.sleep(500L);
        }
        tpc = new TestProxyClient("localhost", 10195);
        userpass = tpc.proxy().login("root", Collections.singletonMap("password", ""));
    }

    @AfterClass
    public static void tearDown() throws InterruptedException {
        proxy.stop();
    }

    @Before
    public void makeTestTable() throws Exception {
        tpc.proxy().createTable(userpass, testtable, true, TimeType.MILLIS);
    }

    @After
    public void deleteTestTable() throws Exception {
        tpc.proxy().deleteTable(userpass, testtable);
    }

    @Test
    public void createExistsDelete() throws TException {
        Assert.assertFalse((boolean)tpc.proxy().tableExists(userpass, "testtable2"));
        tpc.proxy().createTable(userpass, "testtable2", true, TimeType.MILLIS);
        Assert.assertTrue((boolean)tpc.proxy().tableExists(userpass, "testtable2"));
        tpc.proxy().deleteTable(userpass, "testtable2");
        Assert.assertFalse((boolean)tpc.proxy().tableExists(userpass, "testtable2"));
    }

    @Test
    public void listRename() throws TException {
        Assert.assertFalse((boolean)tpc.proxy().tableExists(userpass, "testtable2"));
        tpc.proxy().renameTable(userpass, testtable, "testtable2");
        Assert.assertTrue((boolean)tpc.proxy().tableExists(userpass, "testtable2"));
        tpc.proxy().renameTable(userpass, "testtable2", testtable);
        Assert.assertTrue((boolean)tpc.proxy().listTables(userpass).contains(testtable));
    }

    @Test
    public void merge() throws TException {
        HashSet<ByteBuffer> splits = new HashSet<ByteBuffer>();
        splits.add(ByteBuffer.wrap("a".getBytes()));
        splits.add(ByteBuffer.wrap("c".getBytes()));
        splits.add(ByteBuffer.wrap("z".getBytes()));
        tpc.proxy().addSplits(userpass, testtable, splits);
        tpc.proxy().mergeTablets(userpass, testtable, ByteBuffer.wrap("b".getBytes()), ByteBuffer.wrap("d".getBytes()));
        splits.remove(ByteBuffer.wrap("c".getBytes()));
        List tableSplits = tpc.proxy().listSplits(userpass, testtable, 10);
        for (ByteBuffer split : tableSplits) {
            Assert.assertTrue((boolean)splits.contains(split));
        }
        Assert.assertTrue((tableSplits.size() == splits.size() ? 1 : 0) != 0);
    }

    @Test
    public void splits() throws TException {
        HashSet<ByteBuffer> splits = new HashSet<ByteBuffer>();
        splits.add(ByteBuffer.wrap("a".getBytes()));
        splits.add(ByteBuffer.wrap("b".getBytes()));
        splits.add(ByteBuffer.wrap("z".getBytes()));
        tpc.proxy().addSplits(userpass, testtable, splits);
        List tableSplits = tpc.proxy().listSplits(userpass, testtable, 10);
        for (ByteBuffer split : tableSplits) {
            Assert.assertTrue((boolean)splits.contains(split));
        }
        Assert.assertTrue((tableSplits.size() == splits.size() ? 1 : 0) != 0);
    }

    @Test
    public void constraints() throws TException {
        int cid = tpc.proxy().addConstraint(userpass, testtable, "org.apache.accumulo.TestConstraint");
        Map constraints = tpc.proxy().listConstraints(userpass, testtable);
        Assert.assertEquals((long)((Integer)constraints.get("org.apache.accumulo.TestConstraint")).intValue(), (long)cid);
        tpc.proxy().removeConstraint(userpass, testtable, cid);
        constraints = tpc.proxy().listConstraints(userpass, testtable);
        Assert.assertNull(constraints.get("org.apache.accumulo.TestConstraint"));
    }

    @Test
    public void localityGroups() throws TException {
        HashMap groups = new HashMap();
        HashSet<String> group1 = new HashSet<String>();
        group1.add("cf1");
        groups.put("group1", group1);
        HashSet<String> group2 = new HashSet<String>();
        group2.add("cf2");
        group2.add("cf3");
        groups.put("group2", group2);
        tpc.proxy().setLocalityGroups(userpass, testtable, groups);
        Map actualGroups = tpc.proxy().getLocalityGroups(userpass, testtable);
        Assert.assertEquals((long)groups.size(), (long)actualGroups.size());
        for (String groupName : groups.keySet()) {
            Assert.assertTrue((boolean)actualGroups.containsKey(groupName));
            Assert.assertEquals((long)((Set)groups.get(groupName)).size(), (long)((Set)actualGroups.get(groupName)).size());
            for (String cf : (Set)groups.get(groupName)) {
                Assert.assertTrue((boolean)((Set)actualGroups.get(groupName)).contains(cf));
            }
        }
    }

    @Test
    public void tableProperties() throws TException {
        tpc.proxy().setTableProperty(userpass, testtable, "test.property1", "wharrrgarbl");
        Assert.assertEquals(tpc.proxy().getTableProperties(userpass, testtable).get("test.property1"), (Object)"wharrrgarbl");
        tpc.proxy().removeTableProperty(userpass, testtable, "test.property1");
        Assert.assertNull(tpc.proxy().getTableProperties(userpass, testtable).get("test.property1"));
    }

    private static void addMutation(Map<ByteBuffer, List<ColumnUpdate>> mutations, String row, String cf, String cq, String value) {
        ColumnUpdate update = new ColumnUpdate(ByteBuffer.wrap(cf.getBytes()), ByteBuffer.wrap(cq.getBytes()));
        update.setValue(value.getBytes());
        mutations.put(ByteBuffer.wrap(row.getBytes()), Collections.singletonList(update));
    }

    @Test
    public void tableOperationsRowMethods() throws TException {
        HashMap<ByteBuffer, List<ColumnUpdate>> mutations = new HashMap<ByteBuffer, List<ColumnUpdate>>();
        for (int i = 0; i < 10; ++i) {
            TestProxyTableOperations.addMutation(mutations, "" + i, "cf", "cq", "");
        }
        tpc.proxy().updateAndFlush(userpass, testtable, mutations);
        Assert.assertEquals((Object)tpc.proxy().getMaxRow(userpass, testtable, null, null, true, null, true), (Object)ByteBuffer.wrap("9".getBytes()));
        tpc.proxy().deleteRows(userpass, testtable, ByteBuffer.wrap("51".getBytes()), ByteBuffer.wrap("99".getBytes()));
        Assert.assertEquals((Object)tpc.proxy().getMaxRow(userpass, testtable, null, null, true, null, true), (Object)ByteBuffer.wrap("5".getBytes()));
    }
}

