/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.Test;

public class WriteAheadLogIT
extends AccumuloClusterHarness {
    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_WALOG_MAX_SIZE, "2M");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1");
        cfg.setProperty(Property.GC_CYCLE_START, "1");
        cfg.setProperty(Property.MASTER_RECOVERY_DELAY, "1s");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "1");
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 600;
    }

    @Test
    public void test() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "750K");
        TestIngest.Opts opts = new TestIngest.Opts();
        VerifyIngest.Opts vopts = new VerifyIngest.Opts();
        opts.setTableName(tableName);
        ClientConfiguration clientConfig = cluster.getClientConfig();
        if (clientConfig.hasSasl()) {
            opts.updateKerberosCredentials(clientConfig);
            vopts.updateKerberosCredentials(clientConfig);
        } else {
            opts.setPrincipal(WriteAheadLogIT.getAdminPrincipal());
            vopts.setPrincipal(WriteAheadLogIT.getAdminPrincipal());
        }
        TestIngest.ingest(c, opts, new BatchWriterOpts());
        vopts.setTableName(tableName);
        VerifyIngest.verifyIngest(c, vopts, new ScannerOpts());
        WriteAheadLogIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
        WriteAheadLogIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
        VerifyIngest.verifyIngest(c, vopts, new ScannerOpts());
    }
}

