/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TimedOutException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.SlowConstraint;
import org.apache.accumulo.test.functional.SlowIterator;
import org.junit.Assert;
import org.junit.Test;

public class TimeoutIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 75;
    }

    @Test
    public void run() throws Exception {
        Connector conn = this.getConnector();
        String[] tableNames = this.getUniqueNames(2);
        this.testBatchWriterTimeout(conn, tableNames[0]);
        this.testBatchScannerTimeout(conn, tableNames[1]);
    }

    public void testBatchWriterTimeout(Connector conn, String tableName) throws Exception {
        conn.tableOperations().create(tableName);
        conn.tableOperations().addConstraint(tableName, SlowConstraint.class.getName());
        UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig().setTimeout(3L, TimeUnit.SECONDS));
        Mutation mut = new Mutation((CharSequence)"r1");
        mut.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"v1");
        bw.addMutation(mut);
        try {
            bw.close();
            Assert.fail((String)"batch writer did not timeout");
        }
        catch (MutationsRejectedException mre) {
            if (mre.getCause() instanceof TimedOutException) {
                return;
            }
            throw mre;
        }
    }

    public void testBatchScannerTimeout(Connector conn, String tableName) throws Exception {
        this.getConnector().tableOperations().create(tableName);
        BatchWriter bw = this.getConnector().createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"r1");
        m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"v1");
        m.put((CharSequence)"cf1", (CharSequence)"cq2", (CharSequence)"v2");
        m.put((CharSequence)"cf1", (CharSequence)"cq3", (CharSequence)"v3");
        m.put((CharSequence)"cf1", (CharSequence)"cq4", (CharSequence)"v4");
        bw.addMutation(m);
        bw.close();
        BatchScanner bs = this.getConnector().createBatchScanner(tableName, Authorizations.EMPTY, 2);
        bs.setRanges(Collections.singletonList(new Range()));
        for (Map.Entry entry : bs) {
            entry.getKey();
        }
        bs.setTimeout(5L, TimeUnit.SECONDS);
        IteratorSetting iterSetting = new IteratorSetting(100, SlowIterator.class);
        iterSetting.addOption("sleepTime", "2000");
        bs.addScanIterator(iterSetting);
        try {
            for (Map.Entry entry : bs) {
                entry.getKey();
            }
            Assert.fail((String)"batch scanner did not time out");
        }
        catch (TimedOutException timedOutException) {
            // empty catch block
        }
        bs.close();
    }
}

