/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.client.impl.Writer;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.util.MasterMetadataUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class SplitRecoveryIT
extends ConfigurableMacBase {
    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    private KeyExtent nke(String table, String endRow, String prevEndRow) {
        return new KeyExtent(table, endRow == null ? null : new Text(endRow), prevEndRow == null ? null : new Text(prevEndRow));
    }

    private void run() throws Exception {
        Instance inst = HdfsZooInstance.getInstance();
        AccumuloServerContext c = new AccumuloServerContext(new ServerConfigurationFactory(inst));
        String zPath = ZooUtil.getRoot((Instance)inst) + "/testLock";
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.OVERWRITE);
        ZooLock zl = new ZooLock(zPath);
        boolean gotLock = zl.tryLock(new ZooLock.LockWatcher(){

            public void lostLock(ZooLock.LockLossReason reason) {
                System.exit(-1);
            }

            public void unableToMonitorLockNode(Throwable e) {
                System.exit(-1);
            }
        }, "foo".getBytes(StandardCharsets.UTF_8));
        if (!gotLock) {
            System.err.println("Failed to get lock " + zPath);
        }
        this.runSplitRecoveryTest(c, 0, "sp", 0, zl, this.nke("foo0", null, null));
        this.runSplitRecoveryTest(c, 1, "sp", 0, zl, this.nke("foo1", null, null));
        this.runSplitRecoveryTest(c, 0, "k", 0, zl, this.nke("foo2", "m", null), this.nke("foo2", null, "m"));
        this.runSplitRecoveryTest(c, 1, "k", 0, zl, this.nke("foo3", "m", null), this.nke("foo3", null, "m"));
        this.runSplitRecoveryTest(c, 0, "o", 1, zl, this.nke("foo4", "m", null), this.nke("foo4", null, "m"));
        this.runSplitRecoveryTest(c, 1, "o", 1, zl, this.nke("foo5", "m", null), this.nke("foo5", null, "m"));
        this.runSplitRecoveryTest(c, 0, "o", 1, zl, this.nke("foo6", "m", null), this.nke("foo6", "r", "m"), this.nke("foo6", null, "r"));
        this.runSplitRecoveryTest(c, 1, "o", 1, zl, this.nke("foo7", "m", null), this.nke("foo7", "r", "m"), this.nke("foo7", null, "r"));
        this.runSplitRecoveryTest(c, 0, "g", 0, zl, this.nke("foo8", "m", null), this.nke("foo8", "r", "m"), this.nke("foo8", null, "r"));
        this.runSplitRecoveryTest(c, 1, "g", 0, zl, this.nke("foo9", "m", null), this.nke("foo9", "r", "m"), this.nke("foo9", null, "r"));
        this.runSplitRecoveryTest(c, 0, "w", 2, zl, this.nke("fooa", "m", null), this.nke("fooa", "r", "m"), this.nke("fooa", null, "r"));
        this.runSplitRecoveryTest(c, 1, "w", 2, zl, this.nke("foob", "m", null), this.nke("foob", "r", "m"), this.nke("foob", null, "r"));
    }

    private void runSplitRecoveryTest(AccumuloServerContext context, int failPoint, String mr, int extentToSplit, ZooLock zl, KeyExtent ... extents) throws Exception {
        Text midRow = new Text(mr);
        TreeMap<FileRef, DataFileValue> splitMapFiles = null;
        for (int i = 0; i < extents.length; ++i) {
            KeyExtent extent = extents[i];
            String tdir = ServerConstants.getTablesDirs()[0] + "/" + extent.getTableId() + "/dir_" + i;
            MetadataTableUtil.addTablet((KeyExtent)extent, (String)tdir, (ClientContext)context, (char)'L', (ZooLock)zl);
            TreeMap<FileRef, DataFileValue> mapFiles = new TreeMap<FileRef, DataFileValue>();
            mapFiles.put(new FileRef(tdir + "/" + "rf" + "_000_000"), new DataFileValue((long)(1000017 + i), (long)(10000 + i)));
            if (i == extentToSplit) {
                splitMapFiles = mapFiles;
            }
            int tid = 0;
            TransactionWatcher.ZooArbitrator.start((String)"bulkTx", (long)tid);
            MetadataTableUtil.updateTabletDataFile((long)tid, (KeyExtent)extent, mapFiles, (String)"L0", (ClientContext)context, (ZooLock)zl);
        }
        KeyExtent extent = extents[extentToSplit];
        KeyExtent high = new KeyExtent(extent.getTableId(), extent.getEndRow(), midRow);
        KeyExtent low = new KeyExtent(extent.getTableId(), midRow, extent.getPrevEndRow());
        this.splitPartiallyAndRecover(context, extent, high, low, 0.4, splitMapFiles, midRow, "localhost:1234", failPoint, zl);
    }

    private void splitPartiallyAndRecover(AccumuloServerContext context, KeyExtent extent, KeyExtent high, KeyExtent low, double splitRatio, SortedMap<FileRef, DataFileValue> mapFiles, Text midRow, String location, int steps, ZooLock zl) throws Exception {
        TreeMap<FileRef, DataFileValue> lowDatafileSizes = new TreeMap<FileRef, DataFileValue>();
        TreeMap<FileRef, DataFileValue> highDatafileSizes = new TreeMap<FileRef, DataFileValue>();
        ArrayList highDatafilesToRemove = new ArrayList();
        MetadataTableUtil.splitDatafiles((String)extent.getTableId(), (Text)midRow, (double)splitRatio, new HashMap(), mapFiles, lowDatafileSizes, highDatafileSizes, highDatafilesToRemove);
        MetadataTableUtil.splitTablet((KeyExtent)high, (Text)extent.getPrevEndRow(), (double)splitRatio, (ClientContext)context, (ZooLock)zl);
        TServerInstance instance = new TServerInstance(location, zl.getSessionId());
        Writer writer = MetadataTableUtil.getMetadataTable((ClientContext)context);
        Assignment assignment = new Assignment(high, instance);
        Mutation m = new Mutation(assignment.tablet.getMetadataEntry());
        assignment.server.putFutureLocation(m);
        writer.update(m);
        if (steps >= 1) {
            Map bulkFiles = MetadataTableUtil.getBulkFilesLoaded((ClientContext)context, (KeyExtent)extent);
            MasterMetadataUtil.addNewTablet((ClientContext)context, (KeyExtent)low, (String)"/lowDir", (TServerInstance)instance, lowDatafileSizes, (Map)bulkFiles, (String)"L0", (long)-1L, (long)-1L, (ZooLock)zl);
        }
        if (steps >= 2) {
            MetadataTableUtil.finishSplit((KeyExtent)high, highDatafileSizes, highDatafilesToRemove, (ClientContext)context, (ZooLock)zl);
        }
        TabletServer.verifyTabletInformation((AccumuloServerContext)context, (KeyExtent)high, (TServerInstance)instance, null, (String)"127.0.0.1:0", (ZooLock)zl);
        if (steps >= 1) {
            this.ensureTabletHasNoUnexpectedMetadataEntries(context, low, lowDatafileSizes);
            this.ensureTabletHasNoUnexpectedMetadataEntries(context, high, highDatafileSizes);
            Map lowBulkFiles = MetadataTableUtil.getBulkFilesLoaded((ClientContext)context, (KeyExtent)low);
            Map highBulkFiles = MetadataTableUtil.getBulkFilesLoaded((ClientContext)context, (KeyExtent)high);
            if (!lowBulkFiles.equals(highBulkFiles)) {
                throw new Exception(" " + lowBulkFiles + " != " + highBulkFiles + " " + low + " " + high);
            }
            if (lowBulkFiles.size() == 0) {
                throw new Exception(" no bulk files " + low);
            }
        } else {
            this.ensureTabletHasNoUnexpectedMetadataEntries(context, extent, mapFiles);
        }
    }

    private void ensureTabletHasNoUnexpectedMetadataEntries(AccumuloServerContext context, KeyExtent extent, SortedMap<FileRef, DataFileValue> expectedMapFiles) throws Exception {
        try (ScannerImpl scanner = new ScannerImpl((ClientContext)context, "!0", Authorizations.EMPTY);){
            scanner.setRange(extent.toMetadataRange());
            HashSet<ColumnFQ> expectedColumns = new HashSet<ColumnFQ>();
            expectedColumns.add(MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN);
            expectedColumns.add(MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN);
            expectedColumns.add(MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN);
            expectedColumns.add(MetadataSchema.TabletsSection.ServerColumnFamily.LOCK_COLUMN);
            HashSet<Text> expectedColumnFamilies = new HashSet<Text>();
            expectedColumnFamilies.add(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            expectedColumnFamilies.add(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME);
            expectedColumnFamilies.add(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            expectedColumnFamilies.add(MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME);
            expectedColumnFamilies.add(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME);
            Iterator iter = scanner.iterator();
            while (iter.hasNext()) {
                Key key = (Key)((Map.Entry)iter.next()).getKey();
                if (!key.getRow().equals((Object)extent.getMetadataEntry())) {
                    throw new Exception("Tablet " + extent + " contained unexpected " + "accumulo.metadata" + " entry " + key);
                }
                if (expectedColumnFamilies.contains(key.getColumnFamily()) || expectedColumns.remove(new ColumnFQ(key))) continue;
                throw new Exception("Tablet " + extent + " contained unexpected " + "accumulo.metadata" + " entry " + key);
            }
            System.out.println("expectedColumns " + expectedColumns);
            if (expectedColumns.size() > 1 || expectedColumns.size() == 1) {
                throw new Exception("Not all expected columns seen " + extent + " " + expectedColumns);
            }
            SortedMap fixedMapFiles = MetadataTableUtil.getDataFileSizes((KeyExtent)extent, (ClientContext)context);
            this.verifySame(expectedMapFiles, fixedMapFiles);
        }
    }

    private void verifySame(SortedMap<FileRef, DataFileValue> datafileSizes, SortedMap<FileRef, DataFileValue> fixedDatafileSizes) throws Exception {
        if (!datafileSizes.keySet().containsAll(fixedDatafileSizes.keySet()) || !fixedDatafileSizes.keySet().containsAll(datafileSizes.keySet())) {
            throw new Exception("Key sets not the same " + datafileSizes.keySet() + " !=  " + fixedDatafileSizes.keySet());
        }
        for (Map.Entry<FileRef, DataFileValue> entry : datafileSizes.entrySet()) {
            DataFileValue otherDfv;
            DataFileValue dfv = entry.getValue();
            if (dfv.equals((Object)(otherDfv = (DataFileValue)fixedDatafileSizes.get(entry.getKey())))) continue;
            throw new Exception(entry.getKey() + " dfv not equal  " + dfv + "  " + otherDfv);
        }
    }

    public static void main(String[] args) throws Exception {
        new SplitRecoveryIT().run();
    }

    @Test
    public void test() throws Exception {
        Assert.assertEquals((long)0L, (long)this.exec(SplitRecoveryIT.class, new String[0]).waitFor());
    }
}

