/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class SimpleBalancerFairnessIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_MAXMEM, "10K");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "0");
        cfg.setMemory(ServerType.TABLET_SERVER, cfg.getMemory(ServerType.TABLET_SERVER) * 3L, MemoryUnit.BYTE);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 600;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void simpleBalancerFairness() throws Exception {
        Connector c = this.getConnector();
        c.tableOperations().create("test_ingest");
        c.tableOperations().setProperty("test_ingest", Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K");
        c.tableOperations().create("unused");
        TreeSet<Text> splits = TestIngest.getSplitPoints(0L, 10000000L, 500L);
        log.info("Creating " + splits.size() + " splits");
        c.tableOperations().addSplits("unused", splits);
        List tservers = c.instanceOperations().getTabletServers();
        TestIngest.Opts opts = new TestIngest.Opts();
        opts.rows = 50000;
        opts.setPrincipal("root");
        TestIngest.ingest(c, opts, new BatchWriterOpts());
        c.tableOperations().flush("test_ingest", null, null, false);
        UtilWaitThread.sleepUninterruptibly((long)45L, (TimeUnit)TimeUnit.SECONDS);
        Credentials creds = new Credentials("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
        ClientContext context = new ClientContext(c.getInstance(), creds, this.getClientConfig());
        MasterMonitorInfo stats = null;
        int unassignedTablets = 1;
        for (int i = 0; unassignedTablets > 0 && i < 10; ++i) {
            Object client = null;
            try {
                client = MasterClient.getConnectionWithRetry((ClientContext)context);
                stats = client.getMasterStats(Tracer.traceInfo(), creds.toThrift(c.getInstance()));
            }
            finally {
                if (client != null) {
                    MasterClient.close((MasterClientService.Iface)client);
                }
            }
            unassignedTablets = stats.getUnassignedTablets();
            if (unassignedTablets <= 0) continue;
            log.info("Found " + unassignedTablets + " unassigned tablets, sleeping 3 seconds for tablet assignment");
            Thread.sleep(3000L);
        }
        Assert.assertEquals((String)"Unassigned tablets were not assigned within 30 seconds", (long)0L, (long)unassignedTablets);
        ArrayList<Integer> counts = new ArrayList<Integer>();
        for (TabletServerStatus server : stats.tServerInfo) {
            int count = 0;
            for (TableInfo table : server.tableMap.values()) {
                count += table.onlineTablets;
            }
            counts.add(count);
        }
        Assert.assertTrue((String)"Expected to have at least two TabletServers", (counts.size() > 1 ? 1 : 0) != 0);
        for (int i = 1; i < counts.size(); ++i) {
            int diff = Math.abs((Integer)counts.get(0) - (Integer)counts.get(i));
            Assert.assertTrue((String)("Expected difference in tablets to be less than or equal to " + counts.size() + " but was " + diff + ". Counts " + counts), (diff <= tservers.size() ? 1 : 0) != 0);
        }
    }
}

