/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class MetadataSplitIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setSiteConfig(Collections.singletonMap(Property.TSERV_MAJC_DELAY.getKey(), "100ms"));
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        Connector c = this.getConnector();
        Assert.assertEquals((long)1L, (long)c.tableOperations().listSplits("accumulo.metadata").size());
        c.tableOperations().setProperty("accumulo.metadata", Property.TABLE_SPLIT_THRESHOLD.getKey(), "500");
        for (int i = 0; i < 10; ++i) {
            c.tableOperations().create("table" + i);
            c.tableOperations().flush("accumulo.metadata", null, null, true);
        }
        UtilWaitThread.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertTrue((c.tableOperations().listSplits("accumulo.metadata").size() > 2 ? 1 : 0) != 0);
    }
}

