/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class MetadataIT
extends AccumuloClusterHarness {
    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
    }

    @Override
    public int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void testFlushAndCompact() throws Exception {
        Connector c = this.getConnector();
        String[] tableNames = this.getUniqueNames(2);
        c.tableOperations().create(tableNames[0]);
        Scanner rootScanner = c.createScanner("accumulo.root", Authorizations.EMPTY);
        rootScanner.setRange(MetadataSchema.TabletsSection.getRange());
        rootScanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        HashSet<String> files1 = new HashSet<String>();
        for (Object entry : rootScanner) {
            files1.add(((Key)entry.getKey()).getColumnQualifier().toString());
        }
        c.tableOperations().create(tableNames[1]);
        c.tableOperations().flush("accumulo.metadata", null, null, true);
        HashSet<String> files2 = new HashSet<String>();
        for (Map.Entry entry : rootScanner) {
            files2.add(((Key)entry.getKey()).getColumnQualifier().toString());
        }
        Assert.assertTrue((files2.size() > 0 ? 1 : 0) != 0);
        Assert.assertNotEquals(files1, files2);
        c.tableOperations().compact("accumulo.metadata", null, null, false, true);
        HashSet<String> files3 = new HashSet<String>();
        for (Map.Entry entry : rootScanner) {
            files3.add(((Key)entry.getKey()).getColumnQualifier().toString());
        }
        Assert.assertNotEquals(files2, files3);
    }

    @Test
    public void mergeMeta() throws Exception {
        Connector c = this.getConnector();
        String[] names = this.getUniqueNames(5);
        TreeSet<Text> splits = new TreeSet<Text>();
        for (String id : "1 2 3 4 5".split(" ")) {
            splits.add(new Text(id));
        }
        c.tableOperations().addSplits("accumulo.metadata", splits);
        for (String tableName : names) {
            c.tableOperations().create(tableName);
        }
        c.tableOperations().merge("accumulo.metadata", null, null);
        Scanner s = c.createScanner("accumulo.root", Authorizations.EMPTY);
        s.setRange(MetadataSchema.DeletesSection.getRange());
        while (Iterators.size((Iterator)s.iterator()) == 0) {
            UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.assertEquals((long)0L, (long)c.tableOperations().listSplits("accumulo.metadata").size());
    }

    @Test
    public void batchScanTest() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        BatchScanner s = c.createBatchScanner("accumulo.metadata", Authorizations.EMPTY, 1);
        s.setRanges(Collections.singleton(new Range()));
        int count = 0;
        for (Map.Entry e : s) {
            if (e == null) continue;
            ++count;
        }
        s.close();
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        s = c.createBatchScanner("accumulo.root", Authorizations.EMPTY, 1);
        s.setRanges(Collections.singleton(new Range()));
        count = 0;
        for (Map.Entry e : s) {
            if (e == null) continue;
            ++count;
        }
        s.close();
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
    }
}

