/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.FileNotFoundException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.commons.configuration.ConfigurationException;
import org.junit.Assert;
import org.junit.Test;

public class MasterAssignmentIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        TabletLocationState newTablet;
        Connector c = this.getConnector();
        String tableName = super.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        String tableId = (String)c.tableOperations().tableIdMap().get(tableName);
        do {
            UtilWaitThread.sleep((long)250L);
            newTablet = this.getTabletLocationState(c, tableId);
        } while (newTablet.current == null);
        Assert.assertNull((Object)newTablet.last);
        Assert.assertNull((Object)newTablet.future);
        BatchWriter bw = c.createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"a");
        m.put((CharSequence)"b", (CharSequence)"c", (CharSequence)"d");
        bw.addMutation(m);
        bw.close();
        c.tableOperations().flush(tableName, null, null, true);
        TabletLocationState flushed = this.getTabletLocationState(c, tableId);
        Assert.assertEquals((Object)newTablet.current, (Object)flushed.current);
        Assert.assertEquals((Object)flushed.current, (Object)flushed.last);
        Assert.assertNull((Object)newTablet.future);
        c.tableOperations().offline(tableName, true);
        TabletLocationState offline = this.getTabletLocationState(c, tableId);
        Assert.assertNull((Object)offline.future);
        Assert.assertNull((Object)offline.current);
        Assert.assertEquals((Object)flushed.current, (Object)offline.last);
        c.tableOperations().online(tableName, true);
        TabletLocationState online = this.getTabletLocationState(c, tableId);
        Assert.assertNull((Object)online.future);
        Assert.assertNotNull((Object)online.current);
        Assert.assertEquals((Object)online.current, (Object)online.last);
    }

    private TabletLocationState getTabletLocationState(Connector c, String tableId) throws FileNotFoundException, ConfigurationException {
        Credentials creds = new Credentials(MasterAssignmentIT.getAdminPrincipal(), MasterAssignmentIT.getAdminToken());
        ClientContext context = new ClientContext(c.getInstance(), creds, MasterAssignmentIT.getCluster().getClientConfig());
        MetaDataTableScanner s = new MetaDataTableScanner(context, new Range(KeyExtent.getMetadataEntry((String)tableId, null)));
        TabletLocationState tlState = s.next();
        s.close();
        return tlState;
    }
}

