/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.metrics.MetricsFileTailer;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcMetricsIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(GcMetricsIT.class);
    private static final int NUM_TAIL_ATTEMPTS = 20;
    private static final long TAIL_DELAY = 5000L;
    private static final Pattern metricLinePattern = Pattern.compile("^(?<timestamp>\\d+).*");
    private static final String[] EXPECTED_METRIC_KEYS = new String[]{"AccGcCandidates", "AccGcDeleted", "AccGcErrors", "AccGcFinished", "AccGcInUse", "AccGcPostOpDuration", "AccGcRunCycleCount", "AccGcStarted", "AccGcWalCandidates", "AccGcWalDeleted", "AccGcWalErrors", "AccGcWalFinished", "AccGcWalInUse", "AccGcWalStarted"};
    private final MetricsFileTailer gcTail = new MetricsFileTailer("accumulo.sink.file-gc");

    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.GC_METRICS_ENABLED, "true");
        cfg.setProperty(Property.GC_CYCLE_START, "5s");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "15s");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Before
    public void startTailer() {
        this.gcTail.startDaemonThread();
    }

    @After
    public void stopTailer() {
        this.gcTail.close();
    }

    @Test
    public void gcMetricsPublished() throws Exception {
        Assume.assumeTrue((String)"gc metrics are disabled with GC_METRICS_ENABLED=false", (boolean)this.cluster.getSiteConfiguration().getBoolean(Property.GC_METRICS_ENABLED));
        Assume.assumeFalse((String)"gc metrics are disabled because GENERAL_LEGACY_METRICS=true", (boolean)this.cluster.getSiteConfiguration().getBoolean(Property.GENERAL_LEGACY_METRICS));
        long testStart = System.currentTimeMillis();
        log.debug("Test started: {}", (Object)testStart);
        LineUpdate firstGc = this.captureMetricsAfterTimestamp(testStart);
        log.debug("First captured metrics finished at {}", (Object)firstGc.gcWalFinished);
        LineUpdate secondGc = this.captureMetricsAfterTimestamp(firstGc.gcWalFinished);
        log.debug("Second captured metrics finished at {}", (Object)secondGc.gcWalFinished);
        firstGc.compareWithSubsequentRun(secondGc);
    }

    private LineUpdate captureMetricsAfterTimestamp(long timestamp) throws Exception {
        for (int count = 0; count < 20; ++count) {
            LineUpdate lineUpdate;
            String line = this.gcTail.getLast();
            if (line != null && this.isValidRecentMetricsLine(line, timestamp) && timestamp < (lineUpdate = new LineUpdate(line)).gcStarted && timestamp < lineUpdate.gcWalStarted) {
                return lineUpdate;
            }
            Thread.sleep(5000L);
        }
        throw new IllegalStateException(String.format("File source update not received after %d tries in %d sec", 20, TimeUnit.MILLISECONDS.toSeconds(100000L)));
    }

    private boolean isValidRecentMetricsLine(String line, long prevTimestamp) {
        if (Objects.isNull(line)) {
            return false;
        }
        Matcher m = metricLinePattern.matcher(line);
        if (m.matches()) {
            try {
                long timestamp = Long.parseLong(m.group("timestamp"));
                return timestamp > prevTimestamp;
            }
            catch (NumberFormatException ex) {
                log.debug("Could not parse timestamp from line '{}", (Object)line);
                return false;
            }
        }
        return false;
    }

    private static class LineUpdate {
        private final long gcStarted;
        private final long gcFinished;
        private final long gcWalStarted;
        private final long gcWalFinished;
        private final long gcRunCycleCount;
        private final Map<String, Long> values;

        LineUpdate(String line) {
            this.values = LineUpdate.parseLine(line);
            this.gcStarted = this.values.get("AccGcStarted");
            this.gcFinished = this.values.get("AccGcFinished");
            this.gcWalStarted = this.values.get("AccGcWalStarted");
            this.gcWalFinished = this.values.get("AccGcWalFinished");
            this.gcRunCycleCount = this.values.get("AccGcRunCycleCount");
            Assert.assertTrue((boolean)Stream.of(EXPECTED_METRIC_KEYS).allMatch(this.values::containsKey));
            Assert.assertTrue((this.gcStarted <= this.gcFinished ? 1 : 0) != 0);
            Assert.assertTrue((this.gcWalStarted <= this.gcWalFinished ? 1 : 0) != 0);
        }

        void compareWithSubsequentRun(LineUpdate update) {
            log.debug("First run: {}, Second run: {}", this.values, update.values);
            Assert.assertTrue((String)"first gc should finish before second starts", (this.gcFinished < update.gcStarted ? 1 : 0) != 0);
            Assert.assertTrue((String)"first gcWal should finish before second starts", (this.gcWalFinished < update.gcWalStarted ? 1 : 0) != 0);
            Assert.assertTrue((String)"cycle count should increment", (this.gcRunCycleCount < update.gcRunCycleCount ? 1 : 0) != 0);
        }

        private static Map<String, Long> parseLine(String line) {
            log.debug("Line received:{}", (Object)line);
            Map values = Collections.emptyMap();
            if (line != null) {
                values = Stream.of(line.split(",")).map(String::trim).filter(s -> s.startsWith("AccGc")).map(s -> s.split("=")).collect(Collectors.toMap(a -> a[0], a -> Long.parseLong(a[1]), (a, b) -> {
                    throw new IllegalArgumentException("Metric field found with two values '" + a + "' and '" + b + "' in GC Metrics line: " + line);
                }, TreeMap::new));
            }
            log.debug("Mapped values:{}", values);
            return values;
        }
    }
}

