/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ProcessNotFoundException;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.Test;

public class GarbageCollectorIT
extends ConfigurableMacBase {
    private static final String OUR_SECRET = "itsreallysecret";

    @Override
    public int defaultTimeoutSeconds() {
        return 300;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.INSTANCE_SECRET, OUR_SECRET);
        cfg.setProperty(Property.GC_CYCLE_START, "1");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1");
        cfg.setProperty(Property.GC_PORT, "0");
        cfg.setProperty(Property.TSERV_MAXMEM, "5K");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "1");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    private void killMacGc() throws ProcessNotFoundException, InterruptedException, KeeperException {
        this.getCluster().killProcess(ServerType.GARBAGE_COLLECTOR, (ProcessReference)((Collection)this.getCluster().getProcesses().get(ServerType.GARBAGE_COLLECTOR)).iterator().next());
        String path = ZooUtil.getRoot((Instance)new ZooKeeperInstance(this.getCluster().getClientConfig())) + "/gc/lock";
        ZooReaderWriter zk = new ZooReaderWriter(this.cluster.getZooKeepers(), 30000, OUR_SECRET);
        try {
            ZooLock.deleteLock((IZooReaderWriter)zk, (String)path);
        }
        catch (IllegalStateException e) {
            log.error("Unable to delete ZooLock for mini accumulo-gc", (Throwable)e);
        }
        Assert.assertNull(this.getCluster().getProcesses().get(ServerType.GARBAGE_COLLECTOR));
    }

    @Test
    public void gcTest() throws Exception {
        this.killMacGc();
        Connector c = this.getConnector();
        c.tableOperations().create("test_ingest");
        c.tableOperations().setProperty("test_ingest", Property.TABLE_SPLIT_THRESHOLD.getKey(), "5K");
        TestIngest.Opts opts = new TestIngest.Opts();
        VerifyIngest.Opts vopts = new VerifyIngest.Opts();
        opts.rows = 10000;
        vopts.rows = 10000;
        opts.cols = 1;
        vopts.cols = 1;
        opts.setPrincipal("root");
        vopts.setPrincipal("root");
        TestIngest.ingest(c, this.cluster.getFileSystem(), opts, new BatchWriterOpts());
        c.tableOperations().compact("test_ingest", null, null, true, true);
        int before = this.countFiles();
        while (true) {
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            int more = this.countFiles();
            if (more <= before) break;
            before = more;
        }
        this.getCluster().start();
        UtilWaitThread.sleepUninterruptibly((long)15L, (TimeUnit)TimeUnit.SECONDS);
        int after = this.countFiles();
        VerifyIngest.verifyIngest(c, vopts, new ScannerOpts());
        Assert.assertTrue((after < before ? 1 : 0) != 0);
    }

    @Test
    public void gcLotsOfCandidatesIT() throws Exception {
        this.killMacGc();
        log.info("Filling metadata table with bogus delete flags");
        Connector c = this.getConnector();
        GarbageCollectorIT.addEntries(c, new BatchWriterOpts());
        this.cluster.getConfig().setDefaultMemory(16L, MemoryUnit.MEGABYTE);
        Process gc = this.cluster.exec(SimpleGarbageCollector.class, new String[0]);
        UtilWaitThread.sleepUninterruptibly((long)20L, (TimeUnit)TimeUnit.SECONDS);
        String output = "";
        while (!output.contains("delete candidates has exceeded")) {
            byte[] buffer = new byte[10240];
            try {
                int n = gc.getInputStream().read(buffer);
                output = new String(buffer, 0, n, StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                log.error("IO error reading the IT's accumulo-gc STDOUT", (Throwable)ex);
                break;
            }
        }
        gc.destroy();
        Assert.assertTrue((boolean)output.contains("delete candidates has exceeded"));
    }

    @Test
    public void dontGCRootLog() throws Exception {
        this.killMacGc();
        Connector c = this.getConnector();
        String table = this.getUniqueNames(1)[0];
        c.tableOperations().create(table);
        this.cluster.start();
        UtilWaitThread.sleepUninterruptibly((long)20L, (TimeUnit)TimeUnit.SECONDS);
        this.killMacGc();
        for (ProcessReference ref : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
            this.cluster.killProcess(ServerType.TABLET_SERVER, ref);
        }
        this.cluster.start();
        Scanner scanner = c.createScanner("accumulo.metadata", Authorizations.EMPTY);
        Iterators.size((Iterator)scanner.iterator());
    }

    private Mutation createDelMutation(String path, String cf, String cq, String val) {
        Text row = new Text(MetadataSchema.DeletesSection.getRowPrefix() + path);
        Mutation delFlag = new Mutation(row);
        delFlag.put((CharSequence)cf, (CharSequence)cq, (CharSequence)val);
        return delFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidDelete() throws Exception {
        this.killMacGc();
        String table = this.getUniqueNames(1)[0];
        this.getConnector().tableOperations().create(table);
        BatchWriter bw2 = this.getConnector().createBatchWriter(table, new BatchWriterConfig());
        Mutation m1 = new Mutation((CharSequence)"r1");
        m1.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"v1");
        bw2.addMutation(m1);
        bw2.close();
        this.getConnector().tableOperations().flush(table, null, null, true);
        this.getConnector().securityOperations().grantTablePermission(this.getConnector().whoami(), "accumulo.metadata", TablePermission.WRITE);
        BatchWriter bw3 = this.getConnector().createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        bw3.addMutation(this.createDelMutation("", "", "", ""));
        bw3.addMutation(this.createDelMutation("", "testDel", "test", "valueTest"));
        bw3.addMutation(this.createDelMutation("/", "", "", ""));
        bw3.close();
        Process gc = this.cluster.exec(SimpleGarbageCollector.class, new String[0]);
        try {
            String output = "";
            while (!output.contains("Ignoring invalid deletion candidate")) {
                UtilWaitThread.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
                try {
                    output = FunctionalTestUtils.readAll(this.cluster, SimpleGarbageCollector.class, gc);
                }
                catch (IOException ioe) {
                    log.error("Could not read all from cluster.", (Throwable)ioe);
                }
            }
        }
        finally {
            gc.destroy();
        }
        Scanner scanner = this.getConnector().createScanner(table, Authorizations.EMPTY);
        Iterator iter = scanner.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Map.Entry entry = (Map.Entry)iter.next();
        Assert.assertEquals((Object)"r1", (Object)((Key)entry.getKey()).getRow().toString());
        Assert.assertEquals((Object)"cf1", (Object)((Key)entry.getKey()).getColumnFamily().toString());
        Assert.assertEquals((Object)"cq1", (Object)((Key)entry.getKey()).getColumnQualifier().toString());
        Assert.assertEquals((Object)"v1", (Object)((Value)entry.getValue()).toString());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testProperPortAdvertisement() throws Exception {
        Connector conn = this.getConnector();
        Instance instance = conn.getInstance();
        ZooReaderWriter zk = new ZooReaderWriter(this.cluster.getZooKeepers(), 30000, OUR_SECRET);
        String path = ZooUtil.getRoot((Instance)instance) + "/gc/lock";
        for (int i = 0; i < 5; ++i) {
            List locks;
            try {
                locks = zk.getChildren(path, null);
            }
            catch (KeeperException.NoNodeException e) {
                Thread.sleep(5000L);
                continue;
            }
            if (locks != null && locks.size() > 0) {
                Collections.sort(locks);
                String lockPath = path + "/" + (String)locks.get(0);
                String gcLoc = new String(zk.getData(lockPath, null));
                Assert.assertTrue((String)("Found unexpected data in zookeeper for GC location: " + gcLoc), (boolean)gcLoc.startsWith(ServerServices.Service.GC_CLIENT.name()));
                int loc = gcLoc.indexOf("=");
                Assert.assertNotEquals((String)("Could not find split point of GC location for: " + gcLoc), (long)-1L, (long)loc);
                String addr = gcLoc.substring(loc + 1);
                int addrSplit = addr.indexOf(58);
                Assert.assertNotEquals((String)("Could not find split of GC host:port for: " + addr), (long)-1L, (long)addrSplit);
                String host = addr.substring(0, addrSplit);
                String port = addr.substring(addrSplit + 1);
                Assert.assertNotEquals((Object)"0.0.0.0", (Object)host);
                Assert.assertNotEquals((long)0L, (long)Integer.parseInt(port));
                return;
            }
            Thread.sleep(5000L);
        }
        Assert.fail((String)"Could not find advertised GC address");
    }

    private int countFiles() throws Exception {
        Path path = new Path(this.cluster.getConfig().getDir() + "/accumulo/tables/1/*/*.rf");
        return Iterators.size(Arrays.asList(this.cluster.getFileSystem().globStatus(path)).iterator());
    }

    public static void addEntries(Connector conn, BatchWriterOpts bwOpts) throws Exception {
        conn.securityOperations().grantTablePermission(conn.whoami(), "accumulo.metadata", TablePermission.WRITE);
        BatchWriter bw = conn.createBatchWriter("accumulo.metadata", bwOpts.getBatchWriterConfig());
        for (int i = 0; i < 100000; ++i) {
            Text emptyText = new Text("");
            Text row = new Text(String.format("%s/%020d/%s", MetadataSchema.DeletesSection.getRowPrefix(), i, "aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffffgggggggggghhhhhhhhhhiiiiiiiiiijjjjjjjjjj"));
            Mutation delFlag = new Mutation(row);
            delFlag.put(emptyText, emptyText, new Value(new byte[0]));
            bw.addMutation(delFlag);
        }
        bw.close();
    }
}

