/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Future;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.categories.PerformanceTests;
import org.apache.accumulo.test.categories.StandaloneCapableClusterTests;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={StandaloneCapableClusterTests.class, PerformanceTests.class})
public class DeleteTableDuringSplitIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 900;
    }

    @Test
    public void test() throws Exception {
        String[] tableNames;
        int batches = 12;
        int batchSize = 8;
        for (String tableName : tableNames = this.getUniqueNames(batches * batchSize)) {
            this.getConnector().tableOperations().create(tableName);
        }
        final TreeSet<Text> splits = new TreeSet<Text>();
        for (byte i = 0; i < 100; i = (byte)((byte)(i + 1))) {
            splits.add(new Text(new byte[]{0, 0, i}));
        }
        ArrayList<Future> results = new ArrayList<Future>();
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        SimpleThreadPool es = new SimpleThreadPool(batchSize * 2, "concurrent-api-requests");
        String[] stringArray = tableNames;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String tableName;
            final String finalName = tableName = stringArray[i];
            tasks.add(new Runnable(){

                @Override
                public void run() {
                    try {
                        DeleteTableDuringSplitIT.this.getConnector().tableOperations().addSplits(finalName, splits);
                    }
                    catch (TableNotFoundException tableNotFoundException) {
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(finalName, ex);
                    }
                }
            });
            tasks.add(new Runnable(){

                @Override
                public void run() {
                    try {
                        UtilWaitThread.sleep((long)500L);
                        DeleteTableDuringSplitIT.this.getConnector().tableOperations().delete(finalName);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
        }
        Iterator itr = tasks.iterator();
        for (int batch = 0; batch < batches; ++batch) {
            for (int i = 0; i < batchSize; ++i) {
                Future f = es.submit((Runnable)itr.next());
                results.add(f);
                f = es.submit((Runnable)itr.next());
                results.add(f);
            }
            for (Future f : results) {
                f.get();
            }
            results.clear();
        }
        List queued = es.shutdownNow();
        Assert.assertTrue((String)"Had more tasks to run", (boolean)queued.isEmpty());
        Assert.assertFalse((String)"Had more tasks that needed to be submitted", (boolean)itr.hasNext());
        for (String tableName : tableNames) {
            Assert.assertFalse((boolean)this.getConnector().tableOperations().exists(tableName));
        }
    }
}

