/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteRowsIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(DeleteRowsIT.class);
    private static final int ROWS_PER_TABLET = 10;
    private static final String[] LETTERS = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    static final SortedSet<Text> SPLITS = new TreeSet<Text>();
    static final List<String> ROWS;

    @Override
    protected int defaultTimeoutSeconds() {
        return 300;
    }

    @Test
    public void testDeleteAllRows() throws Exception {
        String[] tableNames;
        Connector c = this.getConnector();
        for (String tableName : tableNames = this.getUniqueNames(20)) {
            c.tableOperations().create(tableName);
            c.tableOperations().deleteRows(tableName, null, null);
            Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);
            Assert.assertEquals((long)0L, (long)Iterators.size((Iterator)scanner.iterator()));
        }
    }

    @Test
    public void testManyRows() throws Exception {
        int i = 0;
        String tableName = this.getUniqueNames(1)[0];
        this.testSplit(tableName + i++, "f", "h", "abcdefijklmnopqrstuvwxyz", 260);
        this.testSplit(tableName + i++, "f1", "h", "abcdeff1ijklmnopqrstuvwxyz", 262);
        this.testSplit(tableName + i++, "f", "h1", "abcdefijklmnopqrstuvwxyz", 258);
        this.testSplit(tableName + i++, "f1", "h1", "abcdeff1ijklmnopqrstuvwxyz", 260);
        this.testSplit(tableName + i++, "f", "g", "abcdefhijklmnopqrstuvwxyz", 270);
        this.testSplit(tableName + i++, "f", "f1", "abcdefghijklmnopqrstuvwxyz", 278);
        this.testSplit(tableName + i++, "f1", "g", "abcdeff1hijklmnopqrstuvwxyz", 272);
        this.testSplit(tableName + i++, null, "h", "ijklmnopqrstuvwxyz", 200);
        this.testSplit(tableName + i++, "t", null, "abcdefghijklmnopqrst", 200);
        this.testSplit(tableName + i++, "t0", "t2", "abcdefghijklmnopqrstt0uvwxyz", 278);
        this.testSplit(tableName + i++, null, "A1", "abcdefghijklmnopqrstuvwxyz", 278);
        this.testSplit(tableName + i++, "{1", null, "abcdefghijklmnopqrstuvwxyz{1", 272);
        this.testSplit(tableName + i++, null, null, "", 0);
    }

    private void testSplit(String table, String start, String end, String result, int entries) throws Exception {
        Connector c = this.getConnector();
        c.tableOperations().create(table);
        BatchWriter bw = c.createBatchWriter(table, null);
        for (String row : ROWS) {
            for (int j = 0; j < 10; ++j) {
                Mutation m = new Mutation((CharSequence)(row + j));
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                bw.addMutation(m);
            }
        }
        bw.flush();
        bw.close();
        c.tableOperations().addSplits(table, SPLITS);
        Text startText = start == null ? null : new Text(start);
        Text endText = end == null ? null : new Text(end);
        c.tableOperations().deleteRows(table, startText, endText);
        Collection remainingSplits = c.tableOperations().listSplits(table);
        StringBuilder sb = new StringBuilder();
        for (Text split : remainingSplits) {
            sb.append(split.toString());
        }
        Assert.assertEquals((Object)result, (Object)sb.toString());
        Scanner scanner = c.createScanner(table, Authorizations.EMPTY);
        int count = 0;
        for (Map.Entry entry : scanner) {
            Text row = ((Key)entry.getKey()).getRow();
            Assert.assertTrue((startText == null || row.compareTo((BinaryComparable)startText) <= 0 || endText == null || row.compareTo((BinaryComparable)endText) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((startText != null || endText != null ? 1 : 0) != 0);
            ++count;
        }
        log.info("Finished table " + table);
        Assert.assertEquals((long)entries, (long)count);
    }

    static {
        for (String alpha : LETTERS) {
            SPLITS.add(new Text(alpha));
        }
        ROWS = new ArrayList<String>(Arrays.asList(LETTERS));
        ROWS.add("A");
        ROWS.add("{");
    }
}

