/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Iterator;
import java.util.Set;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CredentialsIT
extends AccumuloClusterHarness {
    private boolean saslEnabled;
    private String username;
    private String password;
    private Instance inst;

    @Override
    public int defaultTimeoutSeconds() {
        return 120;
    }

    @Before
    public void createLocalUser() throws AccumuloException, AccumuloSecurityException {
        Connector conn = this.getConnector();
        this.inst = conn.getInstance();
        ClientConfiguration clientConf = cluster.getClientConfig();
        ClusterUser user = this.getUser(0);
        this.username = user.getPrincipal();
        this.saslEnabled = clientConf.hasSasl();
        Set users = conn.securityOperations().listLocalUsers();
        if (!users.contains(this.username)) {
            PasswordToken passwdToken = null;
            if (!this.saslEnabled) {
                this.password = user.getPassword();
                passwdToken = new PasswordToken((CharSequence)this.password);
            }
            conn.securityOperations().createLocalUser(this.username, passwdToken);
        }
    }

    @After
    public void deleteLocalUser() throws Exception {
        if (this.saslEnabled) {
            ClusterUser root = this.getAdminUser();
            UserGroupInformation.loginUserFromKeytab((String)root.getPrincipal(), (String)root.getKeytab().getAbsolutePath());
        }
        this.getConnector().securityOperations().dropLocalUser(this.username);
    }

    @Test
    public void testConnectorWithDestroyedToken() throws Exception {
        AuthenticationToken token = this.getUser(0).getToken();
        Assert.assertFalse((boolean)token.isDestroyed());
        token.destroy();
        Assert.assertTrue((boolean)token.isDestroyed());
        try {
            this.inst.getConnector("non_existent_user", token);
            Assert.fail();
        }
        catch (AccumuloSecurityException e) {
            Assert.assertTrue((boolean)e.getSecurityErrorCode().equals((Object)SecurityErrorCode.TOKEN_EXPIRED));
        }
    }

    @Test
    public void testDestroyTokenBeforeRPC() throws Exception {
        AuthenticationToken token = this.getUser(0).getToken();
        Connector userConnector = this.inst.getConnector(this.username, token);
        Scanner scanner = userConnector.createScanner("accumulo.metadata", Authorizations.EMPTY);
        Assert.assertFalse((boolean)token.isDestroyed());
        token.destroy();
        Assert.assertTrue((boolean)token.isDestroyed());
        try {
            Iterator iter = scanner.iterator();
            while (iter.hasNext()) {
                Assert.fail();
            }
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof RuntimeException));
            Assert.assertTrue((boolean)(e.getCause() instanceof AccumuloSecurityException));
            Assert.assertTrue((boolean)((AccumuloSecurityException)((Object)AccumuloSecurityException.class.cast(e.getCause()))).getSecurityErrorCode().equals((Object)SecurityErrorCode.TOKEN_EXPIRED));
        }
    }
}

