/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BulkSplitOptimizationIT
extends AccumuloClusterHarness {
    private String majcDelay;
    static final int ROWS = 100000;
    static final int SPLITS = 99;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "1s");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Before
    public void alterConfig() throws Exception {
        Connector conn = this.getConnector();
        this.majcDelay = (String)conn.instanceOperations().getSystemConfiguration().get(Property.TSERV_MAJC_DELAY.getKey());
        if (!"1s".equals(this.majcDelay)) {
            conn.instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), "1s");
            BulkSplitOptimizationIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            BulkSplitOptimizationIT.getClusterControl().startAllServers(ServerType.TABLET_SERVER);
        }
    }

    @After
    public void resetConfig() throws Exception {
        if (null != this.majcDelay) {
            Connector conn = this.getConnector();
            conn.instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), this.majcDelay);
            BulkSplitOptimizationIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            BulkSplitOptimizationIT.getClusterControl().startAllServers(ServerType.TABLET_SERVER);
        }
    }

    @Test
    public void testBulkSplitOptimization() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "1000");
        c.tableOperations().setProperty(tableName, Property.TABLE_FILE_MAX.getKey(), "1000");
        c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "1G");
        FileSystem fs = cluster.getFileSystem();
        Path testDir = new Path(this.getUsableDir(), "testmf");
        FunctionalTestUtils.createRFiles(c, fs, testDir.toString(), 100000, 99, 8);
        FileStatus[] stats = fs.listStatus(testDir);
        System.out.println("Number of generated files: " + stats.length);
        FunctionalTestUtils.bulkImport(c, fs, tableName, testDir.toString());
        FunctionalTestUtils.checkSplits(c, tableName, 0, 0);
        FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 100, 100);
        this.getConnector().tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "100K");
        UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
        while (this.getConnector().tableOperations().listSplits(tableName).size() < 75) {
            UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        FunctionalTestUtils.checkSplits(c, tableName, 50, 100);
        VerifyIngest.Opts opts = new VerifyIngest.Opts();
        opts.timestamp = 1L;
        opts.dataSize = 50;
        opts.random = 56;
        opts.rows = 100000;
        opts.startRow = 0;
        opts.cols = 1;
        opts.setTableName(tableName);
        AuthenticationToken adminToken = BulkSplitOptimizationIT.getAdminToken();
        if (adminToken instanceof PasswordToken) {
            PasswordToken token = (PasswordToken)BulkSplitOptimizationIT.getAdminToken();
            opts.setPassword(new ClientOpts.Password(new String(token.getPassword(), StandardCharsets.UTF_8)));
            opts.setPrincipal(BulkSplitOptimizationIT.getAdminPrincipal());
        } else if (adminToken instanceof KerberosToken) {
            ClientConfiguration clientConf = cluster.getClientConfig();
            opts.updateKerberosCredentials(clientConf);
        } else {
            Assert.fail((String)"Unknown token type");
        }
        VerifyIngest.verifyIngest(c, opts, new ScannerOpts());
        FunctionalTestUtils.checkRFiles(c, tableName, 50, 100, 1, 4);
    }
}

