/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.examples.simple.dirlist;

import java.util.ArrayList;
import java.util.Map;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.examples.simple.dirlist.FileCount;
import org.apache.accumulo.examples.simple.dirlist.Ingest;
import org.apache.accumulo.examples.simple.dirlist.QueryUtil;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CountIT
extends ConfigurableMacBase {
    private Connector conn;
    private String tableName;

    @Before
    public void setupInstance() throws Exception {
        this.tableName = this.getUniqueNames(1)[0];
        this.conn = this.getConnector();
        this.conn.tableOperations().create(this.tableName);
        BatchWriter bw = this.conn.createBatchWriter(this.tableName, new BatchWriterConfig());
        ColumnVisibility cv = new ColumnVisibility();
        bw.addMutation(Ingest.buildMutation((ColumnVisibility)cv, (String)"/local", (boolean)true, (boolean)false, (boolean)true, (long)272L, (long)12345L, null));
        bw.addMutation(Ingest.buildMutation((ColumnVisibility)cv, (String)"/local/user1", (boolean)true, (boolean)false, (boolean)true, (long)272L, (long)12345L, null));
        bw.addMutation(Ingest.buildMutation((ColumnVisibility)cv, (String)"/local/user2", (boolean)true, (boolean)false, (boolean)true, (long)272L, (long)12345L, null));
        bw.addMutation(Ingest.buildMutation((ColumnVisibility)cv, (String)"/local/file", (boolean)false, (boolean)false, (boolean)false, (long)1024L, (long)12345L, null));
        bw.addMutation(Ingest.buildMutation((ColumnVisibility)cv, (String)"/local/file", (boolean)false, (boolean)false, (boolean)false, (long)1024L, (long)23456L, null));
        bw.addMutation(Ingest.buildMutation((ColumnVisibility)cv, (String)"/local/user1/file1", (boolean)false, (boolean)false, (boolean)false, (long)2024L, (long)12345L, null));
        bw.addMutation(Ingest.buildMutation((ColumnVisibility)cv, (String)"/local/user1/file2", (boolean)false, (boolean)false, (boolean)false, (long)1028L, (long)23456L, null));
        bw.close();
    }

    @Test
    public void test() throws Exception {
        Scanner scanner = this.conn.createScanner(this.tableName, new Authorizations());
        scanner.fetchColumn(new Text("dir"), new Text("counts"));
        Assert.assertFalse((boolean)scanner.iterator().hasNext());
        FileCount.Opts opts = new FileCount.Opts();
        ScannerOpts scanOpts = new ScannerOpts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        opts.instance = this.conn.getInstance().getInstanceName();
        opts.zookeepers = this.conn.getInstance().getZooKeepers();
        opts.setTableName(this.tableName);
        opts.setPrincipal(this.conn.whoami());
        opts.setPassword(new ClientOpts.Password("testRootPassword1"));
        FileCount fc = new FileCount(opts, scanOpts, bwOpts);
        fc.run();
        ArrayList<Pair> expected = new ArrayList<Pair>();
        expected.add(new Pair((Object)QueryUtil.getRow((String)"").toString(), (Object)"1,0,3,3"));
        expected.add(new Pair((Object)QueryUtil.getRow((String)"/local").toString(), (Object)"2,1,2,3"));
        expected.add(new Pair((Object)QueryUtil.getRow((String)"/local/user1").toString(), (Object)"0,2,0,2"));
        expected.add(new Pair((Object)QueryUtil.getRow((String)"/local/user2").toString(), (Object)"0,0,0,0"));
        int i = 0;
        for (Map.Entry e : scanner) {
            Assert.assertEquals((Object)((Key)e.getKey()).getRow().toString(), (Object)((Pair)expected.get(i)).getFirst());
            Assert.assertEquals((Object)((Value)e.getValue()).toString(), (Object)((Pair)expected.get(i)).getSecond());
            ++i;
        }
        Assert.assertEquals((long)i, (long)expected.size());
    }
}

