/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.util.List;

public class GenSplits {
    public static void main(String[] args) {
        long distance;
        int numTablets;
        Opts opts = new Opts();
        JCommander jcommander = new JCommander((Object)opts);
        jcommander.setProgramName(GenSplits.class.getSimpleName());
        try {
            jcommander.parse(args);
        }
        catch (ParameterException pe) {
            System.err.println(pe.getMessage());
            jcommander.usage();
            System.exit(-1);
        }
        if (opts.args == null || opts.args.size() != 1) {
            jcommander.usage();
            System.exit(-1);
        }
        if ((numTablets = Integer.parseInt(opts.args.get(0))) < 1) {
            System.err.println("ERROR: numTablets < 1");
            System.exit(-1);
        }
        if (opts.minRow >= opts.maxRow) {
            System.err.println("ERROR: min >= max");
            System.exit(-1);
        }
        int numSplits = numTablets - 1;
        long split = distance = (opts.maxRow - opts.minRow) / (long)numTablets + 1L;
        for (int i = 0; i < numSplits; ++i) {
            String s = String.format("%016x", split + opts.minRow);
            while (s.charAt(s.length() - 1) == '0') {
                s = s.substring(0, s.length() - 1);
            }
            System.out.println(s);
            split += distance;
        }
    }

    static class Opts {
        @Parameter(names={"--min"}, description="minimum row")
        long minRow = 0L;
        @Parameter(names={"--max"}, description="maximum row")
        long maxRow = Long.MAX_VALUE;
        @Parameter(description="<num tablets>")
        List<String> args = null;

        Opts() {
        }
    }
}

