/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.validators.PositiveInteger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.MapReduceClientOnDefaultTable;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.test.continuous.ContinuousIngest;
import org.apache.accumulo.test.continuous.ContinuousOpts;
import org.apache.accumulo.test.continuous.ContinuousWalk;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class ContinuousMoru
extends Configured
implements Tool {
    private static final String PREFIX = ContinuousMoru.class.getSimpleName() + ".";
    private static final String MAX_CQ = PREFIX + "MAX_CQ";
    private static final String MAX_CF = PREFIX + "MAX_CF";
    private static final String MAX = PREFIX + "MAX";
    private static final String MIN = PREFIX + "MIN";
    private static final String CI_ID = PREFIX + "CI_ID";

    public int run(String[] args) throws IOException, InterruptedException, ClassNotFoundException, AccumuloSecurityException {
        Opts opts = new Opts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        MapReduceClientOnDefaultTable clientOpts = new MapReduceClientOnDefaultTable("ci");
        clientOpts.parseArgs(ContinuousMoru.class.getName(), args, new Object[]{bwOpts, opts});
        Job job = Job.getInstance((Configuration)this.getConf(), (String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis()));
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setInputFormatClass(AccumuloInputFormat.class);
        clientOpts.setAccumuloConfigs(job);
        try {
            Set ranges = clientOpts.getConnector().tableOperations().splitRangeByTablets(clientOpts.getTableName(), new Range(), opts.maxMaps);
            AccumuloInputFormat.setRanges((Job)job, (Collection)ranges);
            AccumuloInputFormat.setAutoAdjustRanges((Job)job, (boolean)false);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        job.setMapperClass(CMapper.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        AccumuloOutputFormat.setBatchWriterOptions((Job)job, (BatchWriterConfig)bwOpts.getBatchWriterConfig());
        Configuration conf = job.getConfiguration();
        conf.setLong(MIN, opts.min);
        conf.setLong(MAX, opts.max);
        conf.setInt(MAX_CF, (int)opts.maxColF);
        conf.setInt(MAX_CQ, (int)opts.maxColQ);
        conf.set(CI_ID, UUID.randomUUID().toString());
        job.waitForCompletion(true);
        clientOpts.stopTracing();
        return job.isSuccessful() ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)CachedConfiguration.getInstance(), (Tool)new ContinuousMoru(), (String[])args);
        if (res != 0) {
            System.exit(res);
        }
    }

    static class Opts
    extends ContinuousOpts {
        @Parameter(names={"--maxColF"}, description="maximum column family value to use", converter=ContinuousOpts.ShortConverter.class)
        short maxColF = Short.MAX_VALUE;
        @Parameter(names={"--maxColQ"}, description="maximum column qualifier value to use", converter=ContinuousOpts.ShortConverter.class)
        short maxColQ = Short.MAX_VALUE;
        @Parameter(names={"--maxMappers"}, description="the maximum number of mappers to use", required=true, validateWith={PositiveInteger.class})
        int maxMaps = 0;

        Opts() {
        }
    }

    public static class CMapper
    extends Mapper<Key, Value, Text, Mutation> {
        private short max_cf;
        private short max_cq;
        private Random random;
        private String ingestInstanceId;
        private byte[] iiId;
        private long count;
        private static final ColumnVisibility EMPTY_VIS = new ColumnVisibility();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            int max_cf = context.getConfiguration().getInt(MAX_CF, -1);
            int max_cq = context.getConfiguration().getInt(MAX_CQ, -1);
            if (max_cf > Short.MAX_VALUE || max_cq > Short.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.max_cf = (short)max_cf;
            this.max_cq = (short)max_cq;
            this.random = new Random();
            this.ingestInstanceId = context.getConfiguration().get(CI_ID);
            this.iiId = this.ingestInstanceId.getBytes(StandardCharsets.UTF_8);
            this.count = 0L;
        }

        public void map(Key key, Value data, Mapper.Context context) throws IOException, InterruptedException {
            ContinuousWalk.validate(key, data);
            if (WritableComparator.compareBytes((byte[])this.iiId, (int)0, (int)this.iiId.length, (byte[])data.get(), (int)0, (int)this.iiId.length) != 0) {
                byte[] val = data.get();
                int offset = ContinuousWalk.getPrevRowOffset(val);
                if (offset > 0) {
                    long rowLong = Long.parseLong(new String(val, offset, 16, StandardCharsets.UTF_8), 16);
                    Mutation m = ContinuousIngest.genMutation(rowLong, this.random.nextInt(this.max_cf), this.random.nextInt(this.max_cq), EMPTY_VIS, this.iiId, this.count++, key.getRowData().toArray(), this.random, true);
                    context.write(null, (Object)m);
                }
            } else {
                context.getCounter((Enum)Counts.SELF_READ).increment(1L);
            }
        }
    }

    static enum Counts {
        SELF_READ;

    }
}

