/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Collections;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanFlushWithTimeIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ScanFlushWithTimeIT.class);

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        log.info("Creating table");
        String tableName = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(tableName);
        log.info("Adding slow iterator");
        IteratorSetting setting = new IteratorSetting(50, SlowIterator.class);
        SlowIterator.setSleepTime(setting, 1000L);
        c.tableOperations().attachIterator(tableName, setting);
        log.info("Splitting the table");
        TreeSet<Text> partitionKeys = new TreeSet<Text>();
        partitionKeys.add(new Text("5"));
        c.tableOperations().addSplits(tableName, partitionKeys);
        log.info("waiting for zookeeper propagation");
        UtilWaitThread.sleep((long)5000L);
        log.info("Adding a few entries");
        BatchWriter bw = c.createBatchWriter(tableName, null);
        for (int i = 0; i < 10; ++i) {
            Mutation m = new Mutation((CharSequence)("" + i));
            m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
            bw.addMutation(m);
        }
        bw.close();
        log.info("Fetching some entries: should timeout and return something");
        log.info("Scanner");
        Scanner s = c.createScanner(tableName, Authorizations.EMPTY);
        s.setBatchTimeout(500L, TimeUnit.MILLISECONDS);
        this.testScanner((ScannerBase)s, 1200L);
        log.info("IsolatedScanner");
        IsolatedScanner is = new IsolatedScanner(s);
        is.setReadaheadThreshold(1L);
        this.testScanner((ScannerBase)is, 2200L);
        log.info("BatchScanner");
        BatchScanner bs = c.createBatchScanner(tableName, Authorizations.EMPTY, 5);
        bs.setBatchTimeout(500L, TimeUnit.MILLISECONDS);
        bs.setRanges(Collections.singletonList(new Range()));
        this.testScanner((ScannerBase)bs, 1200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScanner(ScannerBase s, long expected) {
        long now = System.currentTimeMillis();
        try {
            s.iterator().next();
        }
        finally {
            s.close();
        }
        long diff = System.currentTimeMillis() - now;
        log.info("Diff = {}", (Object)diff);
        Assert.assertTrue((String)("Scanner taking too long to return intermediate results: " + diff), (diff < expected ? 1 : 0) != 0);
    }
}

