/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class RecoveryCompactionsAreFlushesIT
extends AccumuloClusterHarness {
    @Override
    public int defaultTimeoutSeconds() {
        return 180;
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Test
    public void test() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "100");
        c.tableOperations().setProperty(tableName, Property.TABLE_FILE_MAX.getKey(), "3");
        BatchWriter bw = c.createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"a");
        m.put((CharSequence)"b", (CharSequence)"c", new Value("v".getBytes()));
        for (int i = 0; i < 3; ++i) {
            bw.addMutation(m);
            bw.flush();
            c.tableOperations().flush(tableName, null, null, true);
        }
        bw.addMutation(m);
        bw.close();
        ClusterControl control = cluster.getClusterControl();
        control.stopAllServers(ServerType.TABLET_SERVER);
        control.startAllServers(ServerType.TABLET_SERVER);
        Iterators.size((Iterator)c.createScanner(tableName, Authorizations.EMPTY).iterator());
        Scanner s = c.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        for (Map.Entry entry : s) {
            String filename = ((Key)entry.getKey()).getColumnQualifier().toString();
            String[] parts = filename.split("/");
            Assert.assertFalse((boolean)parts[parts.length - 1].startsWith("M"));
        }
    }
}

